/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.factory.CacheKeyFactory;
import ro.isdc.wro.cache.factory.DefaultCacheKeyFactory;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;
import ro.isdc.wro.cache.support.DefaultSynchronizedCacheStrategyDecorator;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.config.metadata.DefaultMetaDataFactory;
import ro.isdc.wro.config.metadata.MetaDataFactory;
import ro.isdc.wro.config.support.ContextPropagatingCallable;
import ro.isdc.wro.config.support.WroConfigurationChangeListener;
import ro.isdc.wro.manager.ResourceBundleProcessor;
import ro.isdc.wro.manager.callback.LifecycleCallback;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.manager.runnable.ReloadCacheRunnable;
import ro.isdc.wro.manager.runnable.ReloadModelRunnable;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.DefaultWroModelFactoryDecorator;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.DefaultGroupExtractor;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.DefaultUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.model.resource.support.DefaultResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.change.ResourceWatcher;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.hash.SHA1HashStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;
import ro.isdc.wro.model.resource.support.naming.NoOpNamingStrategy;
import ro.isdc.wro.model.transformer.WildcardExpanderModelTransformer;
import ro.isdc.wro.util.LazyInitializer;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.SchedulerHelper;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroManager
implements WroConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(WroManager.class);
    @Inject
    private final WroModelFactory modelFactory;
    @Inject
    private final GroupExtractor groupExtractor;
    @Inject
    private final CacheStrategy<CacheKey, CacheValue> cacheStrategy;
    @Inject
    private final ProcessorsFactory processorsFactory;
    @Inject
    private final UriLocatorFactory locatorFactory;
    @Inject
    private final NamingStrategy namingStrategy;
    @Inject
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private final HashStrategy hashStrategy;
    @Inject
    private ResourceBundleProcessor resourceBundleProcessor;
    @Inject
    private final ResourceAuthorizationManager authorizationManager;
    @Inject
    private final CacheKeyFactory cacheKeyFactory;
    @Inject
    private final MetaDataFactory metaDataFactory;
    @Inject
    private final ResourceWatcher resourceWatcher;
    private final SchedulerHelper modelSchedulerHelper = SchedulerHelper.create(new LazyInitializer<Runnable>(){

        @Override
        protected Runnable initialize() {
            return ContextPropagatingCallable.decorate(new ReloadModelRunnable(WroManager.this.getModelFactory()));
        }
    }, ReloadModelRunnable.class.getSimpleName());
    private final SchedulerHelper cacheSchedulerHelper = SchedulerHelper.create(new LazyInitializer<Runnable>(){

        @Override
        protected Runnable initialize() {
            return ContextPropagatingCallable.decorate(new ReloadCacheRunnable(WroManager.this.getCacheStrategy()));
        }
    }, ReloadCacheRunnable.class.getSimpleName());

    private WroManager(Builder builder) {
        this.authorizationManager = builder.authorizationManager;
        this.cacheKeyFactory = builder.cacheKeyFactory;
        this.cacheStrategy = DefaultSynchronizedCacheStrategyDecorator.decorate(builder.cacheStrategy);
        this.callbackRegistry = builder.callbackRegistry;
        this.groupExtractor = builder.groupExtractor;
        this.hashStrategy = builder.hashStrategy;
        this.locatorFactory = builder.locatorFactory;
        this.metaDataFactory = builder.metaDataFactory;
        this.namingStrategy = builder.namingStrategy;
        this.processorsFactory = builder.processorsFactory;
        this.modelFactory = DefaultWroModelFactoryDecorator.decorate(builder.modelFactory, builder.modelTransformers);
        this.resourceWatcher = new ResourceWatcher();
    }

    public final void process() throws IOException {
        WroConfiguration config = Context.get().getConfig();
        this.cacheSchedulerHelper.scheduleWithPeriod(config.getCacheUpdatePeriod());
        this.modelSchedulerHelper.scheduleWithPeriod(config.getModelUpdatePeriod());
        this.resourceBundleProcessor.serveProcessedBundle();
    }

    public final String encodeVersionIntoGroupPath(String groupName, ResourceType resourceType, boolean minimize) {
        CacheKey key = new CacheKey(groupName, resourceType, minimize);
        CacheValue cacheValue = this.cacheStrategy.get(key);
        String groupUrl = this.groupExtractor.encodeGroupUrl(groupName, resourceType, minimize);
        return this.formatVersionedResource(cacheValue.getHash(), groupUrl);
    }

    protected String formatVersionedResource(String hash, String resourcePath) {
        return String.format("%s/%s", hash, resourcePath);
    }

    @Override
    public final void onCachePeriodChanged(long period) {
        LOG.info("onCachePeriodChanged with value {} has been triggered!", (Object)period);
        this.cacheSchedulerHelper.scheduleWithPeriod(period);
        this.cacheStrategy.clear();
    }

    @Override
    public final void onModelPeriodChanged(long period) {
        LOG.info("onModelPeriodChanged with value {} has been triggered!", (Object)period);
        this.getModelFactory().destroy();
        this.modelSchedulerHelper.scheduleWithPeriod(period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            this.cacheSchedulerHelper.destroy();
            this.modelSchedulerHelper.destroy();
            this.cacheStrategy.destroy();
            this.modelFactory.destroy();
            this.resourceWatcher.destroy();
            this.destroyProcessors();
        }
        catch (Exception e) {
            LOG.error("Exception occured during manager destroy!", (Throwable)e);
        }
        finally {
            LOG.debug("WroManager destroyed");
        }
    }

    private void destroyProcessors() throws Exception {
        for (ResourcePreProcessor resourcePreProcessor : this.processorsFactory.getPreProcessors()) {
            if (!(resourcePreProcessor instanceof Destroyable)) continue;
            ((Destroyable)((Object)resourcePreProcessor)).destroy();
        }
        for (ResourcePostProcessor resourcePostProcessor : this.processorsFactory.getPostProcessors()) {
            if (!(resourcePostProcessor instanceof Destroyable)) continue;
            ((Destroyable)((Object)resourcePostProcessor)).destroy();
        }
    }

    public final HashStrategy getHashStrategy() {
        return this.hashStrategy;
    }

    public final WroModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public final ProcessorsFactory getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final CacheStrategy<CacheKey, CacheValue> getCacheStrategy() {
        return this.cacheStrategy;
    }

    public final UriLocatorFactory getUriLocatorFactory() {
        return this.locatorFactory;
    }

    public final NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public final GroupExtractor getGroupExtractor() {
        return this.groupExtractor;
    }

    public CacheKeyFactory getCacheKeyFactory() {
        return this.cacheKeyFactory;
    }

    public MetaDataFactory getMetaDataFactory() {
        return this.metaDataFactory;
    }

    public ResourceWatcher getResourceWatcher() {
        return this.resourceWatcher;
    }

    public final void registerCallback(ObjectFactory<LifecycleCallback> callbackFactory) {
        Validate.notNull(callbackFactory);
        this.getCallbackRegistry().registerCallback(callbackFactory);
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.callbackRegistry = new LifecycleCallbackRegistry();
        }
        return this.callbackRegistry;
    }

    public ResourceAuthorizationManager getResourceAuthorizationManager() {
        return this.authorizationManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private WroModelFactory modelFactory = new EmptyModelFactory();
        private GroupExtractor groupExtractor = new DefaultGroupExtractor();
        private CacheStrategy<CacheKey, CacheValue> cacheStrategy = new LruMemoryCacheStrategy<CacheKey, CacheValue>();
        private ProcessorsFactory processorsFactory = new SimpleProcessorsFactory();
        private UriLocatorFactory locatorFactory = new DefaultUriLocatorFactory();
        private NamingStrategy namingStrategy = new NoOpNamingStrategy();
        private LifecycleCallbackRegistry callbackRegistry = new LifecycleCallbackRegistry();
        private HashStrategy hashStrategy = new SHA1HashStrategy();
        private List<Transformer<WroModel>> modelTransformers = this.createDefaultTransformers();
        private ResourceAuthorizationManager authorizationManager = new DefaultResourceAuthorizationManager();
        private CacheKeyFactory cacheKeyFactory = new DefaultCacheKeyFactory();
        private MetaDataFactory metaDataFactory = new DefaultMetaDataFactory();

        public Builder() {
        }

        public Builder(WroManager manager) {
            Validate.notNull((Object)manager);
            this.groupExtractor = manager.getGroupExtractor();
            this.cacheStrategy = manager.getCacheStrategy();
            this.processorsFactory = manager.getProcessorsFactory();
            this.locatorFactory = manager.getUriLocatorFactory();
            this.namingStrategy = manager.getNamingStrategy();
            this.callbackRegistry = manager.getCallbackRegistry();
            this.hashStrategy = manager.getHashStrategy();
            this.modelFactory = manager.getModelFactory();
            this.authorizationManager = manager.getResourceAuthorizationManager();
            this.cacheKeyFactory = manager.getCacheKeyFactory();
            this.metaDataFactory = manager.getMetaDataFactory();
        }

        public Builder setModelFactory(WroModelFactory modelFactory) {
            this.modelFactory = modelFactory;
            return this;
        }

        public Builder setGroupExtractor(GroupExtractor groupExtractor) {
            Validate.notNull((Object)groupExtractor);
            this.groupExtractor = groupExtractor;
            return this;
        }

        public Builder setCacheStrategy(CacheStrategy<CacheKey, CacheValue> cacheStrategy) {
            Validate.notNull(cacheStrategy);
            this.cacheStrategy = cacheStrategy;
            return this;
        }

        public Builder setProcessorsFactory(ProcessorsFactory processorsFactory) {
            Validate.notNull((Object)processorsFactory);
            this.processorsFactory = processorsFactory;
            return this;
        }

        public Builder setLocatorFactory(UriLocatorFactory locatorFactory) {
            Validate.notNull((Object)locatorFactory);
            this.locatorFactory = locatorFactory;
            return this;
        }

        public Builder setNamingStrategy(NamingStrategy namingStrategy) {
            Validate.notNull((Object)namingStrategy);
            this.namingStrategy = namingStrategy;
            return this;
        }

        public Builder setCallbackRegistry(LifecycleCallbackRegistry callbackRegistry) {
            Validate.notNull((Object)callbackRegistry);
            this.callbackRegistry = callbackRegistry;
            return this;
        }

        public Builder setHashStrategy(HashStrategy hashStrategy) {
            Validate.notNull((Object)hashStrategy);
            this.hashStrategy = hashStrategy;
            return this;
        }

        public Builder setModelTransformers(List<Transformer<WroModel>> modelTransformers) {
            Validate.notNull(modelTransformers);
            this.modelTransformers = modelTransformers;
            return this;
        }

        public Builder setAuthorizationManager(ResourceAuthorizationManager authorizationManager) {
            Validate.notNull((Object)authorizationManager);
            this.authorizationManager = authorizationManager;
            return this;
        }

        public Builder setCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
            Validate.notNull((Object)cacheKeyFactory);
            this.cacheKeyFactory = cacheKeyFactory;
            return this;
        }

        public Builder setMetaDataFactory(MetaDataFactory metaDataFactory) {
            Validate.notNull((Object)metaDataFactory);
            this.metaDataFactory = metaDataFactory;
            return this;
        }

        private List<Transformer<WroModel>> createDefaultTransformers() {
            ArrayList<Transformer<WroModel>> list = new ArrayList<Transformer<WroModel>>();
            list.add(new WildcardExpanderModelTransformer());
            return list;
        }

        public WroManager build() {
            WroManager manager = new WroManager(this);
            InjectorBuilder.create(manager).build().inject(manager);
            return manager;
        }
    }

    private static class EmptyModelFactory
    implements WroModelFactory {
        private EmptyModelFactory() {
        }

        public WroModel create() {
            return new WroModel();
        }

        public void destroy() {
        }
    }
}

