/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.handler.RequestHandler;
import ro.isdc.wro.http.handler.factory.RequestHandlerFactory;
import ro.isdc.wro.http.handler.factory.SimpleRequestHandlerFactory;
import ro.isdc.wro.http.handler.spi.RequestHandlerProvider;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.provider.ProviderFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestHandlerFactory
extends SimpleRequestHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestHandlerFactory.class);

    public static RequestHandlerFactory decorate(final RequestHandlerFactory decorated, final ObjectFactory<Injector> injectorProvider) {
        return new RequestHandlerFactory(){

            @Override
            public Collection<RequestHandler> create() {
                Collection handlers = (Collection)decorated.create();
                for (RequestHandler handler : handlers) {
                    ((Injector)injectorProvider.create()).inject(handler);
                }
                return handlers;
            }
        };
    }

    public DefaultRequestHandlerFactory() {
        List<Object> requestHandlerProviders = Collections.emptyList();
        try {
            requestHandlerProviders = ProviderFinder.of(RequestHandlerProvider.class).find();
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        ArrayList<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
        for (RequestHandlerProvider requestHandlerProvider : requestHandlerProviders) {
            LOG.debug("using provider: {}", (Object)requestHandlerProvider);
            requestHandlers.addAll(requestHandlerProvider.provideRequestHandlers().values());
        }
        this.setHandlers(requestHandlers);
    }
}

