/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.http.readonly;

import javax.validation.constraints.NotNull;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class DocRequestFilter {
    private final NuxeoPrincipal principal;
    private final String indices;
    private final String types;
    private final String documentId;
    private final String rawQuery;

    public DocRequestFilter(NuxeoPrincipal principal, String indices, String types, String documentId, String rawQuery) {
        this.principal = principal;
        this.indices = indices;
        this.types = types;
        this.documentId = documentId;
        this.rawQuery = rawQuery;
    }

    @NotNull
    protected String getUrl() {
        String url = "/" + this.indices + "/" + this.types + "/" + this.documentId;
        if (this.rawQuery != null) {
            url = url + "?" + this.rawQuery;
        }
        return url;
    }

    public String toString() {
        return "Get Doc url: " + this.getUrl() + " user: " + this.principal;
    }

    public String getCheckAccessUrl() {
        return "/" + this.indices + "/" + this.types + "/" + this.documentId + "?fields=ecm:acl";
    }
}

