/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.jsf.component;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Name(value="annotationsActions")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class AnnotationsActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AnnotationsActions.class);
    public static final String TEXT_ANNOTATIONS_KEY = "nuxeo.text.annotations";
    @In(create=true)
    protected transient Principal currentUser;

    public long getAnnotationsCount(DocumentModel doc) {
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
        AnnotationsService annotationsService = (AnnotationsService)Framework.getLocalService(AnnotationsService.class);
        DocumentViewImpl docView = new DocumentViewImpl(doc);
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        String documentUrl = documentViewCodecManager.getUrlFromDocumentView("docpath", (DocumentView)docView, true, VirtualHostHelper.getBaseURL((ServletRequest)request));
        try {
            return annotationsService.getAnnotationsCount(new URI(documentUrl), (NuxeoPrincipal)this.currentUser);
        }
        catch (URISyntaxException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public boolean isAnnotationsEnabled(DocumentModel doc) {
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob blob = blobHolder.getBlob();
        if (blob == null || blob.getMimeType() == null) {
            return false;
        }
        return blob.getMimeType().startsWith("image") || this.isTextAnnotationsEnabled();
    }

    protected boolean isTextAnnotationsEnabled() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        return cs.isBooleanPropertyTrue(TEXT_ANNOTATIONS_KEY);
    }
}

