/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.util;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.SpanElement;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Range;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.TextGrabberVisitor;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Visitor;

public class XPathUtil {
    public String getXPath(Node node) {
        Log.debug((String)("XPathUtil] node: " + node.getNodeName() + " parent node: " + node.getParentNode().getNodeName()));
        Document document = node.getOwnerDocument();
        Node current = node;
        StringBuilder xpath = new StringBuilder();
        while (!current.equals((Object)document)) {
            int counter = 1;
            String name = current.getNodeName();
            while (current.getPreviousSibling() != null) {
                if (current.getPreviousSibling().getNodeName().equalsIgnoreCase(name) && !this.isIgnored(current.getPreviousSibling())) {
                    ++counter;
                }
                current = current.getPreviousSibling();
            }
            xpath.insert(0, "/" + name.toLowerCase() + "[" + counter + "]");
            current = current.getParentNode();
        }
        Log.debug((String)("XPathUtil] xpath: " + xpath));
        return xpath.toString();
    }

    public String getSelectionXPointer(Range range) {
        int start = range.getStartOffset();
        Node clickedNode = range.getStartContainer();
        Node parentNode = clickedNode.getParentNode();
        if (clickedNode.getNodeType() == 3) {
            TextGrabberVisitor processor = new TextGrabberVisitor();
            Visitor visitor = new Visitor(processor);
            visitor.process(parentNode, clickedNode);
            start += processor.getText().length();
        }
        Log.debug((String)("getSelectionXPointer; start: " + start));
        return "#xpointer(string-range(" + this.getXPath(parentNode) + ",\"\"," + start + "," + this.getShortLength(range.getSelectedText()) + "))";
    }

    public int getShortLength(String selectedText) {
        for (String removed : new String[]{"\n", "\r"}) {
            selectedText = selectedText.replace(removed, "");
        }
        return selectedText.length();
    }

    public List<Node> getNode(String xpath, Document document) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (xpath.startsWith("//")) {
            xpath = xpath.substring(2);
            NodeList n = document.getElementsByTagName(xpath);
            for (int x = 0; x < n.getLength(); ++x) {
                nodes.add(n.getItem(x));
            }
            return nodes;
        }
        Log.debug((String)("XPathUtil#getNode -- xpath: " + xpath));
        String[] paths = xpath.split("/");
        Document result = document;
        block1: for (String path : paths) {
            if ("".equals(path)) continue;
            NodeList nodeList = result.getChildNodes();
            String name = path.substring(0, path.indexOf("["));
            int index = Integer.parseInt(path.substring(path.indexOf("[") + 1, path.indexOf("]")));
            int counter = 1;
            for (int x = 0; x < nodeList.getLength(); ++x) {
                Node node = nodeList.getItem(x);
                if (!node.getNodeName().equalsIgnoreCase(name) || this.isIgnored(node)) continue;
                if (counter == index) {
                    result = node;
                    continue block1;
                }
                ++counter;
            }
        }
        nodes.add((Node)result);
        Log.debug((String)"XPathUtil#getNode -- end function: ");
        return nodes;
    }

    private boolean isIgnored(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType != 1 && nodeType != 3) {
            return true;
        }
        if (node.getNodeName().equalsIgnoreCase("span")) {
            SpanElement spanElement = (SpanElement)SpanElement.as((Node)node).cast();
            String name = spanElement.getClassName();
            if (name == null) {
                return false;
            }
            return name.contains("ignoredElement");
        }
        if (node.getNodeName().equalsIgnoreCase("div")) {
            DivElement divElement = (DivElement)DivElement.as((Node)node).cast();
            return divElement.getClassName().equals("ignoredElement");
        }
        return false;
    }

    public boolean isChildOfIgnored(Node node) {
        boolean ignored = false;
        while (node != null && !ignored) {
            ignored = this.isIgnored(node);
            node = node.getParentNode();
        }
        return ignored;
    }

    public static String toIdableName(String xpath) {
        xpath = "X" + xpath;
        xpath = xpath.replace("/", "-");
        xpath = xpath.replace("[", "_");
        return xpath.replace("]", ":");
    }

    public static String fromIdableName(String xpath) {
        xpath = xpath.substring(1);
        xpath = xpath.replace("-", "/");
        xpath = xpath.replace("_", "[");
        return xpath.replace(":", "]");
    }
}

