/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

public class Base64 {
    private static char[] s_alphabet;
    private static byte[] s_codes;

    public static char[] encode(byte[] a_data) {
        char[] l_out = new char[(a_data.length + 2) / 3 * 4];
        int ii = 0;
        int l_index = 0;
        while (ii < a_data.length) {
            boolean l_quad = false;
            boolean l_trip = false;
            int l_val = 0xFF & a_data[ii];
            l_val <<= 8;
            if (ii + 1 < a_data.length) {
                l_val |= 0xFF & a_data[ii + 1];
                l_trip = true;
            }
            l_val <<= 8;
            if (ii + 2 < a_data.length) {
                l_val |= 0xFF & a_data[ii + 2];
                l_quad = true;
            }
            l_out[l_index + 3] = s_alphabet[l_quad ? l_val & 0x3F : 64];
            l_out[l_index + 2] = s_alphabet[l_trip ? (l_val >>= 6) & 0x3F : 64];
            l_out[l_index + 1] = s_alphabet[(l_val >>= 6) & 0x3F];
            l_out[l_index + 0] = s_alphabet[(l_val >>= 6) & 0x3F];
            ii += 3;
            l_index += 4;
        }
        return l_out;
    }

    public static byte[] decode(char[] a_data) {
        int l_tempLen = a_data.length;
        for (int ii = 0; ii < a_data.length; ++ii) {
            if (a_data[ii] <= '\u00ff' && s_codes[a_data[ii]] >= 0) continue;
            --l_tempLen;
        }
        int l_len = l_tempLen / 4 * 3;
        if (l_tempLen % 4 == 3) {
            l_len += 2;
        }
        if (l_tempLen % 4 == 2) {
            ++l_len;
        }
        byte[] l_out = new byte[l_len];
        int l_shift = 0;
        int l_accum = 0;
        int l_index = 0;
        for (int ii = 0; ii < a_data.length; ++ii) {
            int l_value;
            int n = l_value = a_data[ii] > '\u00ff' ? -1 : s_codes[a_data[ii]];
            if (l_value < 0) continue;
            l_accum <<= 6;
            l_accum |= l_value;
            if ((l_shift += 6) < 8) continue;
            l_out[l_index++] = (byte)(l_accum >> (l_shift -= 8) & 0xFF);
        }
        if (l_index != l_out.length) {
            throw new Error("Miscalculated data length (wrote " + l_index + " instead of " + l_out.length + ")");
        }
        return l_out;
    }

    static {
        int ii;
        s_alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        s_codes = new byte[256];
        for (ii = 0; ii < 256; ++ii) {
            Base64.s_codes[ii] = -1;
        }
        for (ii = 65; ii <= 90; ++ii) {
            Base64.s_codes[ii] = (byte)(ii - 65);
        }
        for (ii = 97; ii <= 122; ++ii) {
            Base64.s_codes[ii] = (byte)(26 + ii - 97);
        }
        for (ii = 48; ii <= 57; ++ii) {
            Base64.s_codes[ii] = (byte)(52 + ii - 48);
        }
        Base64.s_codes[43] = 62;
        Base64.s_codes[47] = 63;
    }
}

