/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;

public abstract class AbstractSimpleComponentsMonitor
implements ComponentsMonitor {
    private List components;

    public AbstractSimpleComponentsMonitor(String[] components) {
        this.components = new LinkedList<String>(Arrays.asList(components));
    }

    public ComponentsMonitor useComponent(String component) throws IllegalArgumentException {
        if (!this.components.remove(component)) {
            throw new IllegalArgumentException("Unregistered or previously used component: " + component);
        }
        return this;
    }

    public boolean allComponentsUsed() {
        return this.components.isEmpty();
    }

    public List getRemainingComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public abstract boolean finalStateValid();
}

