/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone.commands;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.guards.Guard;
import org.w3c.dom.Element;

public abstract class AbstractCommand
implements Command {
    protected final String id;
    protected final Map<String, Object> guardVars;
    protected String fail;
    protected String ignore;

    protected AbstractCommand(String id) {
        this.id = id;
        this.guardVars = new HashMap<String, Object>();
    }

    public AbstractCommand(AbstractCommand command) {
        this.id = command.id;
        this.guardVars = command.guardVars;
    }

    public boolean isPostInstall() {
        return false;
    }

    protected abstract Command doRun(Task var1, Map<String, String> var2) throws PackageException;

    protected abstract void doValidate(Task var1, ValidationStatus var2) throws PackageException;

    public void validate(Task task, ValidationStatus status) throws PackageException {
        if (this.fail != null && new Guard(this.fail).evaluate(this.guardVars)) {
            status.addError("Guard failed for command " + this.getId() + ": " + this.fail);
        }
        this.doValidate(task, status);
    }

    public Command run(Task task, Map<String, String> prefs) throws PackageException {
        if (this.ignore()) {
            return null;
        }
        return this.doRun(task, prefs);
    }

    public String getId() {
        return this.id;
    }

    public void setFail(String fail) {
        this.fail = fail;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
    }

    public boolean ignore() throws PackageException {
        if (this.ignore != null) {
            return new Guard(this.ignore).evaluate(this.guardVars);
        }
        return false;
    }

    public void initialize(Element element) throws PackageException {
        String v = element.getAttribute("fail");
        if (v.length() > 0) {
            this.fail = v;
        }
        if ((v = element.getAttribute("ignore")).length() > 0) {
            this.ignore = v;
        }
        this.readFrom(element);
    }

    public abstract void readFrom(Element var1) throws PackageException;
}

