/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.facet.VersioningDocument;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.runtime.api.Framework;

public class VersioningDocumentAdapter
implements VersioningDocument {
    public final DocumentModel doc;
    public final VersioningService service = (VersioningService)Framework.getService(VersioningService.class);

    public VersioningDocumentAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public Long getMajorVersion() {
        return this.getValidVersionNumber("uid:major_version");
    }

    public Long getMinorVersion() {
        return this.getValidVersionNumber("uid:minor_version");
    }

    public String getVersionLabel() {
        return this.service.getVersionLabel(this.doc);
    }

    private long getValidVersionNumber(String propName) {
        Serializable propVal = this.doc.getPropertyValue(propName);
        return propVal == null || !(propVal instanceof Long) ? 0L : (Long)propVal;
    }
}

