/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.CoreService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.ecm.core.versioning.OrphanVersionRemovalFilter;
import org.nuxeo.runtime.api.Framework;

public class OrphanVersionRemoverListener
implements PostCommitEventListener {
    protected static final Log log = LogFactory.getLog(OrphanVersionRemoverListener.class);

    public void handleEvent(EventBundle events) {
        if (events.containsEventName("orphan_versions_to_remove")) {
            for (Event event : events) {
                if (!event.getName().equals("orphan_versions_to_remove")) continue;
                EventContext ctx = event.getContext();
                CoreSession session = ctx.getCoreSession();
                Object[] args = ctx.getArguments();
                if (args.length != 2) continue;
                DocumentModel doc = (DocumentModel)args[0];
                ShallowDocumentModel deletedLiveDoc = null;
                deletedLiveDoc = doc instanceof ShallowDocumentModel ? (ShallowDocumentModel)doc : new ShallowDocumentModel(doc);
                List versionUUIDs = (List)args[1];
                this.removeIfPossible(session, deletedLiveDoc, versionUUIDs);
            }
        }
    }

    protected Collection<OrphanVersionRemovalFilter> getFilters() {
        return ((CoreService)((Object)Framework.getLocalService(CoreService.class))).getOrphanVersionRemovalFilters();
    }

    protected void removeIfPossible(CoreSession session, ShallowDocumentModel deletedLiveDoc, List<String> versionUUIDs) {
        OrphanVersionRemovalFilter filter;
        session.save();
        Iterator<Object> iterator = this.getFilters().iterator();
        while (iterator.hasNext() && (versionUUIDs = (filter = iterator.next()).getRemovableVersionIds(session, deletedLiveDoc, versionUUIDs)).size() != 0) {
        }
        for (String id : versionUUIDs) {
            IdRef idRef = new IdRef(id);
            if (!session.exists((DocumentRef)idRef)) continue;
            log.debug((Object)("Removing version: " + id));
            session.removeDocument((DocumentRef)idRef);
        }
        session.save();
    }
}

