/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.uidgen;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.uidgen.UIDGenerator;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUIDGenerator
implements UIDGenerator {
    private static final Log log = LogFactory.getLog(AbstractUIDGenerator.class);
    private UIDSequencer sequencer;
    private String[] propertyNames;

    @Override
    public final void setSequencer(UIDSequencer sequencer) {
        if (null == sequencer) {
            throw new IllegalArgumentException("null sequencer");
        }
        this.sequencer = sequencer;
    }

    protected int getNext(DocumentModel document) {
        if (null == this.sequencer) {
            throw new IllegalStateException("sequencer not defined");
        }
        String key = this.getSequenceKey(document);
        assert (key != null);
        return this.sequencer.getNext(key);
    }

    @Override
    public String getPropertyName() {
        if (this.propertyNames.length == 0) {
            log.warn((Object)"No propertyName specified");
            return null;
        }
        return this.propertyNames[0];
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyNames = new String[]{propertyName};
    }

    @Override
    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    protected final boolean isPropValueDefined(String propName, DocumentModel document) {
        try {
            Object val = document.getProperty(AbstractUIDGenerator.getSchemaName(propName), AbstractUIDGenerator.getFieldName(propName));
            return val != null;
        }
        catch (PropertyException e) {
            return false;
        }
    }

    protected final String str(String propName, DocumentModel document) {
        Object val = document.getProperty(AbstractUIDGenerator.getSchemaName(propName), AbstractUIDGenerator.getFieldName(propName));
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        throw new NuxeoException("Doc property '" + propName + "' is not of String type.");
    }

    @Override
    public void setUID(DocumentModel document) throws PropertyNotFoundException {
        String uid = this.createUID(document);
        for (String propertyName : this.propertyNames) {
            try {
                document.setProperty(AbstractUIDGenerator.getSchemaName(propertyName), AbstractUIDGenerator.getFieldName(propertyName), (Object)uid);
            }
            catch (PropertyNotFoundException e) {
                e.addInfo(String.format("Cannot set uid %s on property %s for doc %s", uid, propertyName, document));
                throw e;
            }
        }
    }

    private static String getSchemaName(String propertyName) {
        String[] s = propertyName.split(":");
        String prefix = s[0];
        SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
        Schema schema = tm.getSchemaFromPrefix(prefix);
        if (schema == null) {
            return prefix;
        }
        return schema.getName();
    }

    private static String getFieldName(String propertyName) {
        String[] s = propertyName.split(":");
        return s[1];
    }
}

