/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.security.MergedPermissionDescriptor;
import org.nuxeo.ecm.core.security.PermissionDescriptor;
import org.nuxeo.ecm.core.security.PermissionProviderLocal;
import org.nuxeo.ecm.core.security.PermissionUIItemDescriptor;
import org.nuxeo.ecm.core.security.PermissionVisibilityDescriptor;

public class DefaultPermissionProvider
implements PermissionProviderLocal {
    private static final Log log = LogFactory.getLog(DefaultPermissionProvider.class);
    private final List<PermissionDescriptor> registeredPermissions = new LinkedList<PermissionDescriptor>();
    private Map<String, MergedPermissionDescriptor> mergedPermissions;
    private Map<String, Set<String>> mergedGroups;
    private final List<PermissionVisibilityDescriptor> registeredPermissionsVisibility = new LinkedList<PermissionVisibilityDescriptor>();
    private Map<String, PermissionVisibilityDescriptor> mergedPermissionsVisibility = null;

    public synchronized List<UserVisiblePermission> getUserVisiblePermissionDescriptors(String typeName) {
        PermissionVisibilityDescriptor defaultVisibility;
        if (this.mergedPermissionsVisibility == null) {
            this.computeMergedPermissionsVisibility();
        }
        if ((defaultVisibility = this.mergedPermissionsVisibility.get(typeName)) == null) {
            defaultVisibility = this.mergedPermissionsVisibility.get("");
        }
        if (defaultVisibility == null) {
            throw new NuxeoException("no permission visibility configuration registered");
        }
        return defaultVisibility.getSortedUIPermissionDescriptor();
    }

    public List<UserVisiblePermission> getUserVisiblePermissionDescriptors() {
        return this.getUserVisiblePermissionDescriptors("");
    }

    protected void computeMergedPermissionsVisibility() {
        this.mergedPermissionsVisibility = new HashMap<String, PermissionVisibilityDescriptor>();
        for (PermissionVisibilityDescriptor pvd : this.registeredPermissionsVisibility) {
            PermissionVisibilityDescriptor mergedPvd = this.mergedPermissionsVisibility.get(pvd.getTypeName());
            if (mergedPvd == null) {
                mergedPvd = new PermissionVisibilityDescriptor(pvd);
                if (!StringUtils.isEmpty((String)pvd.getTypeName())) {
                    PermissionVisibilityDescriptor defaultPerms = new PermissionVisibilityDescriptor(this.mergedPermissionsVisibility.get(""));
                    defaultPerms.merge(mergedPvd);
                    mergedPvd.setPermissionUIItems(defaultPerms.getPermissionUIItems().toArray(new PermissionUIItemDescriptor[0]));
                }
                this.mergedPermissionsVisibility.put(mergedPvd.getTypeName(), mergedPvd);
                continue;
            }
            mergedPvd.merge(pvd);
        }
    }

    public synchronized String[] getSubPermissions(String perm) {
        List<String> permissions = this.getPermission(perm).getSubPermissions();
        return permissions.toArray(new String[permissions.size()]);
    }

    public synchronized String[] getAliasPermissions(String perm) {
        List<String> permissions = this.getPermission(perm).getSubPermissions();
        return permissions.toArray(new String[permissions.size()]);
    }

    protected MergedPermissionDescriptor getPermission(String perm) {
        MergedPermissionDescriptor mpd;
        if (this.mergedPermissions == null) {
            this.computeMergedPermissions();
        }
        if ((mpd = this.mergedPermissions.get(perm)) == null) {
            throw new NuxeoException(perm + " is not a registered permission");
        }
        return mpd;
    }

    public synchronized String[] getPermissionGroups(String perm) {
        Set<String> groups;
        if (this.mergedGroups == null) {
            this.computeMergedGroups();
        }
        if ((groups = this.mergedGroups.get(perm)) != null && !groups.isEmpty()) {
            return groups.toArray(new String[groups.size()]);
        }
        return null;
    }

    protected void computeMergedGroups() {
        Set<String> groups;
        if (this.mergedPermissions == null) {
            this.computeMergedPermissions();
        }
        this.mergedGroups = new HashMap<String, Set<String>>();
        for (MergedPermissionDescriptor mpd : this.mergedPermissions.values()) {
            for (String subPermission : mpd.getSubPermissions()) {
                groups = this.mergedGroups.get(subPermission);
                if (groups == null) {
                    groups = new TreeSet<String>();
                    groups.add(mpd.getName());
                    this.mergedGroups.put(subPermission, groups);
                    continue;
                }
                if (groups.contains(mpd.getName())) continue;
                groups.add(mpd.getName());
            }
        }
        HashSet<String> alreadyProcessed = new HashSet<String>();
        for (Map.Entry<String, Set<String>> groupEntry : this.mergedGroups.entrySet()) {
            String permissionName = groupEntry.getKey();
            groups = groupEntry.getValue();
            Set<String> allGroups = this.computeAllGroups(permissionName, alreadyProcessed);
            groups.addAll(allGroups);
        }
    }

    protected Set<String> computeAllGroups(String permissionName, Set<String> alreadyProcessed) {
        Set<String> allGroups = this.mergedGroups.get(permissionName);
        if (allGroups == null) {
            allGroups = new TreeSet<String>();
        }
        if (alreadyProcessed.contains(permissionName)) {
            return allGroups;
        }
        alreadyProcessed.add(permissionName);
        for (String directGroupName : new TreeSet<String>(allGroups)) {
            allGroups.addAll(this.computeAllGroups(directGroupName, alreadyProcessed));
        }
        return allGroups;
    }

    public synchronized String[] getPermissions() {
        if (this.mergedPermissions == null) {
            this.computeMergedPermissions();
        }
        return this.mergedPermissions.keySet().toArray(new String[this.mergedPermissions.size()]);
    }

    protected void computeMergedPermissions() {
        this.mergedPermissions = new HashMap<String, MergedPermissionDescriptor>();
        for (PermissionDescriptor pd : this.registeredPermissions) {
            MergedPermissionDescriptor mpd = this.mergedPermissions.get(pd.getName());
            if (mpd == null) {
                mpd = new MergedPermissionDescriptor(pd);
                this.mergedPermissions.put(mpd.getName(), mpd);
                continue;
            }
            mpd.mergeDescriptor(pd);
        }
    }

    @Override
    public synchronized void registerDescriptor(PermissionDescriptor descriptor) {
        HashSet<String> alreadyRegistered = new HashSet<String>();
        for (PermissionDescriptor registeredPerm : this.registeredPermissions) {
            alreadyRegistered.add(registeredPerm.getName());
        }
        for (String includePerm : descriptor.getIncludePermissions()) {
            if (alreadyRegistered.contains(includePerm)) continue;
            throw new NuxeoException(String.format("Permission '%s' included by '%s' is not a registered permission", includePerm, descriptor.getName()));
        }
        this.mergedPermissions = null;
        this.mergedGroups = null;
        this.registeredPermissions.add(descriptor);
    }

    @Override
    public synchronized void unregisterDescriptor(PermissionDescriptor descriptor) {
        int lastOccurence = this.registeredPermissions.lastIndexOf(descriptor);
        if (lastOccurence != -1) {
            this.mergedPermissions = null;
            this.mergedGroups = null;
            this.registeredPermissions.remove(lastOccurence);
        }
    }

    @Override
    public synchronized void registerDescriptor(PermissionVisibilityDescriptor descriptor) {
        this.mergedPermissionsVisibility = null;
        this.registeredPermissionsVisibility.add(descriptor);
    }

    @Override
    public synchronized void unregisterDescriptor(PermissionVisibilityDescriptor descriptor) {
        int lastOccurence = this.registeredPermissionsVisibility.lastIndexOf(descriptor);
        if (lastOccurence != -1) {
            this.mergedPermissionsVisibility = null;
            this.registeredPermissionsVisibility.remove(lastOccurence);
        }
    }
}

