/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.IOException;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.model.Document;

public class BinaryBlobProvider
implements BlobProvider {
    protected final BinaryManager binaryManager;
    protected boolean supportsUserUpdate;

    public BinaryBlobProvider(BinaryManager binaryManager) {
        this.binaryManager = binaryManager;
    }

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        this.binaryManager.initialize(blobProviderId, properties);
        this.supportsUserUpdate = this.supportsUserUpdateDefaultTrue(properties);
    }

    @Override
    public boolean supportsUserUpdate() {
        return this.supportsUserUpdate;
    }

    protected boolean supportsUserUpdateDefaultTrue(Map<String, String> properties) {
        return !Boolean.parseBoolean(properties.get("preventUserUpdate"));
    }

    @Override
    public void close() {
        this.binaryManager.close();
    }

    @Override
    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    @Override
    public Blob readBlob(BlobManager.BlobInfo blobInfo) throws IOException {
        Binary binary;
        String digest = blobInfo.key;
        int colon = digest.indexOf(58);
        if (colon >= 0) {
            digest = digest.substring(colon + 1);
        }
        if ((binary = this.binaryManager.getBinary(digest)) == null) {
            throw new IOException("Unknown binary: " + digest);
        }
        return new BinaryBlob(binary, blobInfo.key, blobInfo.filename, blobInfo.mimeType, blobInfo.encoding, blobInfo.digest, binary.getLength());
    }

    @Override
    public String writeBlob(Blob blob, Document doc) throws IOException {
        return this.binaryManager.getBinary(blob).getDigest();
    }
}

