/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.runtime.api.Framework;

public class Binary
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String digest;
    protected final String blobProviderId;
    protected transient File file;
    protected long length;

    protected Binary(String digest, String blobProviderId) {
        this(null, digest, blobProviderId);
    }

    public Binary(File file, String digest, String blobProviderId) {
        this.file = file;
        this.digest = digest;
        this.blobProviderId = blobProviderId;
        this.length = -1L;
    }

    protected long computeLength() {
        if (this.file == null) {
            return -1L;
        }
        return this.file.length();
    }

    public long getLength() {
        if (this.length == -1L) {
            this.length = this.computeLength();
        }
        return this.length;
    }

    public String getDigestAlgorithm() {
        String digest = this.getDigest();
        if (digest == null) {
            return null;
        }
        return AbstractBinaryManager.DIGESTS_BY_LENGTH.get(digest.length());
    }

    public String getDigest() {
        return this.digest;
    }

    public String getBlobProviderId() {
        return this.blobProviderId;
    }

    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.digest + ')';
    }

    public File getFile() {
        return this.file;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.file = this.recomputeFile();
    }

    protected File recomputeFile() {
        BlobManager bm = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider bp = bm.getBlobProvider(this.blobProviderId);
        return bp.getBinaryManager().getBinary((String)this.digest).file;
    }
}

