/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nuxeo.ecm.core.CoreServiceOrphanVersionRemovalFilterDescriptor;
import org.nuxeo.ecm.core.CoreServicePolicyDescriptor;
import org.nuxeo.ecm.core.versioning.DefaultVersionRemovalPolicy;
import org.nuxeo.ecm.core.versioning.OrphanVersionRemovalFilter;
import org.nuxeo.ecm.core.versioning.VersionRemovalPolicy;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CoreService
extends DefaultComponent {
    private static final String VERSION_REMOVAL_POLICY_XP = "versionRemovalPolicy";
    private static final String ORPHAN_VERSION_REMOVAL_FILTER_XP = "orphanVersionRemovalFilter";
    protected static final DefaultVersionRemovalPolicy DEFAULT_VERSION_REMOVAL_POLICY = new DefaultVersionRemovalPolicy();
    protected Map<CoreServicePolicyDescriptor, VersionRemovalPolicy> versionRemovalPolicies = new LinkedHashMap<CoreServicePolicyDescriptor, VersionRemovalPolicy>();
    protected Map<CoreServiceOrphanVersionRemovalFilterDescriptor, OrphanVersionRemovalFilter> orphanVersionRemovalFilters = new LinkedHashMap<CoreServiceOrphanVersionRemovalFilterDescriptor, OrphanVersionRemovalFilter>();
    protected ComponentContext context;

    public void activate(ComponentContext context) {
        this.context = context;
    }

    public void deactivate(ComponentContext context) {
        this.context = null;
    }

    public void registerContribution(Object contrib, String point, ComponentInstance contributor) {
        if (VERSION_REMOVAL_POLICY_XP.equals(point)) {
            this.registerVersionRemovalPolicy((CoreServicePolicyDescriptor)contrib);
        } else if (ORPHAN_VERSION_REMOVAL_FILTER_XP.equals(point)) {
            this.registerOrphanVersionRemovalFilter((CoreServiceOrphanVersionRemovalFilterDescriptor)contrib);
        } else {
            throw new RuntimeException("Unknown extension point: " + point);
        }
    }

    public void unregisterContribution(Object contrib, String point, ComponentInstance contributor) {
        if (VERSION_REMOVAL_POLICY_XP.equals(point)) {
            this.unregisterVersionRemovalPolicy((CoreServicePolicyDescriptor)contrib);
        } else if (ORPHAN_VERSION_REMOVAL_FILTER_XP.equals(point)) {
            this.unregisterOrphanVersionRemovalFilter((CoreServiceOrphanVersionRemovalFilterDescriptor)contrib);
        }
    }

    protected void registerVersionRemovalPolicy(CoreServicePolicyDescriptor contrib) {
        String klass = contrib.getKlass();
        try {
            VersionRemovalPolicy policy = (VersionRemovalPolicy)this.context.getRuntimeContext().loadClass(klass).newInstance();
            this.versionRemovalPolicies.put(contrib, policy);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate versionRemovalPolicy: " + klass, e);
        }
    }

    protected void unregisterVersionRemovalPolicy(CoreServicePolicyDescriptor contrib) {
        this.versionRemovalPolicies.remove(contrib);
    }

    protected void registerOrphanVersionRemovalFilter(CoreServiceOrphanVersionRemovalFilterDescriptor contrib) {
        String klass = contrib.getKlass();
        try {
            OrphanVersionRemovalFilter filter = (OrphanVersionRemovalFilter)this.context.getRuntimeContext().loadClass(klass).newInstance();
            this.orphanVersionRemovalFilters.put(contrib, filter);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate orphanVersionRemovalFilter: " + klass, e);
        }
    }

    protected void unregisterOrphanVersionRemovalFilter(CoreServiceOrphanVersionRemovalFilterDescriptor contrib) {
        this.orphanVersionRemovalFilters.remove(contrib);
    }

    public VersionRemovalPolicy getVersionRemovalPolicy() {
        if (this.versionRemovalPolicies.isEmpty()) {
            return DEFAULT_VERSION_REMOVAL_POLICY;
        }
        VersionRemovalPolicy versionRemovalPolicy = null;
        Iterator<VersionRemovalPolicy> iterator = this.versionRemovalPolicies.values().iterator();
        while (iterator.hasNext()) {
            VersionRemovalPolicy policy;
            versionRemovalPolicy = policy = iterator.next();
        }
        return versionRemovalPolicy;
    }

    public Collection<OrphanVersionRemovalFilter> getOrphanVersionRemovalFilters() {
        return this.orphanVersionRemovalFilters.values();
    }
}

