/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.impl;

import java.io.File;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;

public abstract class AbstractRendition
implements Rendition {
    protected final RenditionDefinition definition;
    protected static final Log log = LogFactory.getLog(AbstractRendition.class);

    public AbstractRendition(RenditionDefinition definition) {
        this.definition = definition;
    }

    @Override
    public String getIcon() {
        return this.definition.getIcon();
    }

    @Override
    public String getName() {
        return this.definition.getName();
    }

    @Override
    public String getCmisName() {
        return this.definition.getCmisName();
    }

    @Override
    public String getLabel() {
        return this.definition.getLabel();
    }

    @Override
    public String getKind() {
        return this.definition.getKind();
    }

    protected RenditionDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public Calendar getModificationDate() {
        if (this.isStored()) {
            DocumentModel hdoc = this.getHostDocument();
            if (hdoc != null) {
                try {
                    return (Calendar)hdoc.getPropertyValue("dc:modified");
                }
                catch (PropertyException e) {
                    log.error((Object)e);
                }
            }
        } else if (this.isCompleted()) {
            File file;
            Calendar cal = Calendar.getInstance();
            Blob blob = this.getBlob();
            if (blob != null && (file = blob.getFile()) != null) {
                cal.setTimeInMillis(file.lastModified());
            }
            return cal;
        }
        return null;
    }

    @Override
    public String getProviderType() {
        return this.definition.getProviderType();
    }
}

