/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.webcontainer;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.webapp.webcontainer.ThemeActions;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.FlavorDescriptor;
import org.nuxeo.theme.styling.service.descriptors.IconDescriptor;
import org.nuxeo.theme.styling.service.descriptors.LogoDescriptor;

@Name(value="themeActions")
@Scope(value=ScopeType.PAGE)
public class ThemeActionsBean
implements ThemeActions {
    private static final long serialVersionUID = 1L;
    protected String defaultPage;
    protected String currentPage;
    protected String currentFlavor;
    protected LogoDescriptor currentLogo;
    protected List<IconDescriptor> currentFavicons;
    @In(create=true, required=false)
    protected transient ThemeStylingService themeStylingService;

    @Override
    public String getDefaultTheme() {
        if (this.defaultPage == null) {
            this.defaultPage = this.themeStylingService.negotiate("jsfDefaultPage", (Object)FacesContext.getCurrentInstance());
        }
        return this.defaultPage;
    }

    @Override
    public LogoDescriptor getLogo() {
        if (this.currentLogo == null) {
            String flavor = this.getCurrentFlavor();
            this.currentLogo = this.getLogo(flavor);
        }
        return this.currentLogo;
    }

    public List<IconDescriptor> getFavicons() {
        if (this.currentFavicons == null) {
            String flavor = this.getCurrentFlavor();
            FlavorDescriptor f = this.themeStylingService.getFlavor(flavor);
            this.currentFavicons = new ArrayList<IconDescriptor>();
            if (f != null) {
                List icons = f.getFavicons();
                this.currentFavicons.addAll(icons);
            }
        }
        return this.currentFavicons;
    }

    @Override
    public String getCurrentFlavor() {
        if (this.currentFlavor == null) {
            FacesContext faces = FacesContext.getCurrentInstance();
            HttpServletRequest request = (HttpServletRequest)faces.getExternalContext().getRequest();
            request.setAttribute("jsfPage", (Object)this.getCurrentPage());
            this.currentFlavor = this.themeStylingService.negotiate("jsfFlavor", (Object)FacesContext.getCurrentInstance());
        }
        return this.currentFlavor;
    }

    @Override
    public String getCurrentFlavor(String pageName) {
        if (this.currentPage == null || !this.currentPage.equals(pageName)) {
            this.setCurrentPage(pageName);
            this.currentFlavor = null;
        }
        return this.getCurrentFlavor();
    }

    @Override
    public String getCurrentPage() {
        if (this.currentPage == null) {
            this.currentPage = this.themeStylingService.negotiate("jsfPage", (Object)FacesContext.getCurrentInstance());
            if (this.currentPage == null) {
                this.currentPage = this.getDefaultTheme();
            }
        }
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(String pageName) {
        this.currentPage = pageName;
    }

    @Override
    public LogoDescriptor getLogo(String flavorName) {
        if (flavorName == null) {
            return null;
        }
        return this.themeStylingService.getLogo(flavorName);
    }

    @Override
    public FlavorDescriptor getFlavor(String flavorName) {
        if (flavorName == null) {
            return null;
        }
        return this.themeStylingService.getFlavor(flavorName);
    }
}

