/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.documenttemplates;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.action.TypesTool;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.documenttemplates.DocumentTemplatesActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="documentTemplatesActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentTemplatesActionsBean
extends InputController
implements DocumentTemplatesActions,
Serializable {
    public static final String TemplateRoot = "TemplateRoot";
    private static final Log log = LogFactory.getLog(DocumentTemplatesActionsBean.class);
    private static final long serialVersionUID = -4031259222075515590L;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @In(required=false)
    private transient DocumentActions documentActions;
    @In(required=false)
    private TypesTool typesTool;
    @In(required=false)
    protected DocumentModel changeableDocument;
    @In(required=false, create=true)
    protected transient NavigationContext navigationContext;
    private DocumentModelList templates;
    private String selectedTemplateId;
    private String targetType = "Workspace";

    @Override
    @Factory(value="availableTemplates", scope=ScopeType.EVENT)
    public DocumentModelList templatesListFactory() {
        this.templates = this.getTemplates();
        return this.templates;
    }

    @Override
    public DocumentModelList getTemplates(String targetTypeName) {
        if (this.documentManager == null) {
            log.error((Object)"Unable to access documentManager");
            return null;
        }
        String query = "SELECT * FROM Document where ecm:primaryType = '%s' AND ecm:path STARTSWITH %s";
        DocumentModelList tl = this.documentManager.query(String.format(query, TemplateRoot, NXQL.escapeString((String)this.navigationContext.getCurrentDomainPath())));
        if (tl.isEmpty()) {
            this.templates = tl;
        } else {
            this.templates = this.documentManager.getChildren(((DocumentModel)tl.get(0)).getRef(), targetTypeName);
            ArrayList<DocumentModel> deleted = new ArrayList<DocumentModel>();
            for (DocumentModel current : this.templates) {
                if (!"deleted".equals(current.getCurrentLifeCycleState())) continue;
                deleted.add(current);
            }
            this.templates.removeAll(deleted);
        }
        return this.templates;
    }

    @Override
    public DocumentModelList getTemplates() {
        if (this.targetType == null || this.targetType.equals("")) {
            this.targetType = this.typesTool.getSelectedType().getId();
        }
        return this.getTemplates(this.targetType);
    }

    @Override
    public String createDocumentFromTemplate(DocumentModel doc, String templateId) {
        this.selectedTemplateId = templateId;
        return this.createDocumentFromTemplate(doc);
    }

    @Override
    public String createDocumentFromTemplate(DocumentModel doc) {
        if (this.documentManager == null) {
            log.error((Object)"Unable to access documentManager");
            return null;
        }
        if (this.selectedTemplateId == null || this.selectedTemplateId.equals("")) {
            if (this.documentActions != null) {
                return this.documentActions.saveDocument(doc);
            }
            log.error((Object)"Unable to find documentActions");
            return null;
        }
        DocumentRef currentDocRef = this.navigationContext.getCurrentDocument().getRef();
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        String name = pss.generatePathSegment(doc);
        DocumentModel created = this.documentManager.copy((DocumentRef)new IdRef(this.selectedTemplateId), currentDocRef, name, new CoreSession.CopyOption[]{CoreSession.CopyOption.RESET_CREATOR});
        String title = (String)doc.getProperty("dublincore", "title");
        created.setProperty("dublincore", "title", (Object)title);
        String descr = (String)doc.getProperty("dublincore", "description");
        created.setProperty("dublincore", "description", (Object)descr);
        Blob blob = (Blob)doc.getProperty("file", "content");
        if (blob != null) {
            created.setProperty("file", "content", (Object)blob);
            String fname = (String)doc.getProperty("file", "filename");
            created.setProperty("file", "filename", (Object)fname);
        }
        created = this.documentManager.saveDocument(created);
        this.documentManager.save();
        this.selectedTemplateId = "";
        this.logDocumentWithTitle("Created the document: ", created);
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_saved"), new Object[]{this.resourcesAccessor.getMessages().get(created.getType())});
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.currentDocument});
        return this.navigationContext.navigateToDocument(created, "after-create");
    }

    @Override
    public String createDocumentFromTemplate() {
        return this.createDocumentFromTemplate(this.changeableDocument);
    }

    @Override
    public String getSelectedTemplateId() {
        return this.selectedTemplateId;
    }

    @Override
    public void setSelectedTemplateId(String requestedId) {
        this.selectedTemplateId = requestedId;
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    @Override
    @Observer(value={"documentChildrenChanged"}, create=false)
    @BypassInterceptors
    public void documentChildrenChanged() {
        if (this.templates != null) {
            this.templates.clear();
        }
    }

    @Override
    @Observer(value={"domainSelectionChanged"}, create=false)
    @BypassInterceptors
    public void domainChanged() {
        if (this.templates != null) {
            this.templates.clear();
        }
    }
}

