/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api.document;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.document.AdditionalDocumentAuditParams;
import org.nuxeo.ecm.platform.audit.api.document.SourceDocumentResolver;
import org.nuxeo.runtime.api.Framework;

public class DocumentAuditHelper {
    public static AdditionalDocumentAuditParams getAuditParamsForUUID(String uuid, CoreSession session) {
        AdditionalDocumentAuditParams result;
        IdRef ref = new IdRef(uuid);
        if (!session.exists((DocumentRef)ref)) {
            return null;
        }
        DocumentModel doc = session.getDocument((DocumentRef)ref);
        if (!doc.isProxy() && !doc.isVersion()) {
            return null;
        }
        SourceDocumentResolver resolver = new SourceDocumentResolver(session, doc);
        resolver.runUnrestricted();
        if (resolver.sourceDocument == null) {
            return null;
        }
        String targetUUID = resolver.sourceDocument.getId();
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        FilterMapEntry filter = new FilterMapEntry();
        filter.setColumnName("eventId");
        filter.setOperator("=");
        filter.setQueryParameterName("eventId");
        filter.setObject("documentCreated");
        HashMap<String, FilterMapEntry> filters = new HashMap<String, FilterMapEntry>();
        filters.put("eventId", filter);
        List<LogEntry> entries = reader.getLogEntriesFor(uuid, filters, false);
        if (entries != null && entries.size() > 0) {
            result = new AdditionalDocumentAuditParams();
            result.maxDate = entries.get(0).getEventDate();
            result.targetUUID = targetUUID;
            result.eventId = entries.get(0).getId();
        } else {
            if (doc.getPropertyValue("dc:modified") == null) {
                return null;
            }
            result = new AdditionalDocumentAuditParams();
            Calendar estimatedDate = (Calendar)doc.getPropertyValue("dc:modified");
            StringBuilder queryString = new StringBuilder();
            queryString.append("from LogEntry log where log.docUUID in (");
            queryString.append("'" + targetUUID + "'");
            if (doc.isVersion()) {
                DocumentModelList proxies = session.getProxies(doc.getRef(), null);
                for (DocumentModel proxy : proxies) {
                    queryString.append(",'" + proxy.getId() + "'");
                }
            }
            queryString.append(",'" + doc.getId() + "'");
            queryString.append(") AND log.eventId IN (");
            queryString.append("'documentCreated'");
            queryString.append(",'documentCheckedIn'");
            queryString.append(") AND log.eventDate >= :minDate ");
            queryString.append(" order by log.eventId asc");
            estimatedDate.add(14, -500);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("minDate", estimatedDate.getTime());
            List<?> dateEntries = reader.nativeQuery(queryString.toString(), params, 0, 20);
            if (dateEntries.size() > 0) {
                result.targetUUID = targetUUID;
                GregorianCalendar maxDate = new GregorianCalendar();
                maxDate.setTime(((LogEntry)dateEntries.get(0)).getEventDate());
                ((Calendar)maxDate).add(14, -500);
                result.maxDate = maxDate.getTime();
            } else {
                result.targetUUID = targetUUID;
                result.maxDate = ((Calendar)doc.getPropertyValue("dc:modified")).getTime();
            }
        }
        return result;
    }
}

