/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropFind;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.properties.LockDiscovery;
import net.java.dev.webdav.jaxrs.xml.properties.SupportedLock;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.ecm.webdav.jaxrs.IsFolder;
import org.nuxeo.ecm.webdav.jaxrs.Util;
import org.nuxeo.ecm.webdav.resource.ExistingResource;
import org.nuxeo.ecm.webdav.resource.PropStatBuilderExt;

public class FolderResource
extends ExistingResource {
    private static final Log log = LogFactory.getLog(FolderResource.class);

    public FolderResource(String path, DocumentModel doc, HttpServletRequest request, Backend backend) {
        super(path, doc, request, backend);
    }

    @GET
    @Produces(value={"text/html"})
    public String get() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><p>");
        sb.append("Folder listing for ");
        sb.append(this.path);
        sb.append("/");
        sb.append("</p>\n<ul>\n");
        List<DocumentModel> children = this.backend.getChildren(this.doc.getRef());
        for (DocumentModel child : children) {
            String name = this.backend.getDisplayName(child);
            String qname = StringEscapeUtils.escapeHtml((String)name);
            sb.append("<li><a href=\"");
            sb.append(qname);
            if (child.isFolder()) {
                sb.append("/");
            }
            sb.append("\">");
            sb.append(qname);
            sb.append("</a></li>\n");
        }
        sb.append("</ul></body>\n");
        return sb.toString();
    }

    @PROPFIND
    public Response propfind(@Context UriInfo uriInfo, @HeaderParam(value="depth") String depth) throws IOException, JAXBException {
        if (depth == null) {
            depth = "1";
        }
        Unmarshaller u = Util.getUnmarshaller();
        Prop prop = null;
        if (this.request.getInputStream() != null && this.request.getContentLength() > 0) {
            PropFind propFind;
            try {
                propFind = (PropFind)u.unmarshal((InputStream)this.request.getInputStream());
            }
            catch (JAXBException e) {
                log.error((Object)e);
                return Response.status((int)400).build();
            }
            prop = propFind.getProp();
        }
        net.java.dev.webdav.jaxrs.xml.elements.Response response = this.createResponse(this.doc, uriInfo, prop, false);
        if (!this.doc.isFolder() || depth.equals("0")) {
            return Response.status((int)207).entity((Object)new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{response})).build();
        }
        ArrayList<net.java.dev.webdav.jaxrs.xml.elements.Response> responses = new ArrayList<net.java.dev.webdav.jaxrs.xml.elements.Response>();
        responses.add(response);
        List<DocumentModel> children = this.backend.getChildren(this.doc.getRef());
        for (DocumentModel child : children) {
            net.java.dev.webdav.jaxrs.xml.elements.Response childResponse = this.createResponse(child, uriInfo, prop);
            responses.add(childResponse);
        }
        MultiStatus st = new MultiStatus(responses.toArray(new net.java.dev.webdav.jaxrs.xml.elements.Response[responses.size()]));
        return Response.status((int)207).entity((Object)st).build();
    }

    protected net.java.dev.webdav.jaxrs.xml.elements.Response createResponse(DocumentModel doc, UriInfo uriInfo, Prop prop) throws URIException {
        return this.createResponse(doc, uriInfo, prop, true);
    }

    protected net.java.dev.webdav.jaxrs.xml.elements.Response createResponse(DocumentModel doc, UriInfo uriInfo, Prop prop, boolean append) throws URIException {
        net.java.dev.webdav.jaxrs.xml.elements.Response response;
        PropStatBuilderExt props = this.getPropStatBuilderExt(doc, uriInfo);
        PropStat propStatFound = props.build();
        PropStat propStatNotFound = null;
        if (prop != null) {
            propStatNotFound = props.notFound(prop);
        }
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        if (append) {
            uriBuilder.path(URIUtil.encodePath((String)this.backend.getDisplayName(doc)));
        }
        URI uri = uriBuilder.build(new Object[0]);
        if (doc.isFolder()) {
            PropStat folderPropStat = new PropStat(new Prop(new Object[]{new LockDiscovery(), new SupportedLock(), new IsFolder("t")}), new Status(Response.Status.OK));
            response = propStatNotFound != null ? new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, propStatFound, new PropStat[]{propStatNotFound, folderPropStat}) : new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, propStatFound, new PropStat[]{folderPropStat});
        } else {
            response = propStatNotFound != null ? new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, propStatFound, new PropStat[]{propStatNotFound}) : new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, propStatFound, new PropStat[0]);
        }
        return response;
    }
}

