/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;

public class EsResultSetImpl
implements IterableQueryResult,
Iterator<Map<String, Serializable>> {
    private final SearchResponse response;
    private final Map<String, Type> selectFieldsAndTypes;
    boolean closed;
    protected List<Map<String, Serializable>> maps;
    protected long size;
    private long pos;

    public EsResultSetImpl(SearchResponse response, Map<String, Type> selectFieldsAndTypes) {
        this.response = response;
        this.selectFieldsAndTypes = selectFieldsAndTypes;
        this.maps = this.buildMaps();
        this.size = this.maps.size();
    }

    protected List<Map<String, Serializable>> buildMaps() {
        ArrayList<Map<String, Serializable>> rows = new ArrayList<Map<String, Serializable>>(this.response.getHits().getHits().length);
        HashMap<String, Object> emptyRow = new HashMap<String, Object>(this.selectFieldsAndTypes.size());
        for (String fieldName : this.selectFieldsAndTypes.keySet()) {
            emptyRow.put(fieldName, null);
        }
        for (SearchHit hit : this.response.getHits().getHits()) {
            HashMap<String, Serializable> row = new HashMap<String, Serializable>(emptyRow);
            for (SearchHitField field : hit.getFields().values()) {
                Type type;
                String name = field.getName();
                Serializable value = (Serializable)field.getValue();
                if (value instanceof String && (type = this.selectFieldsAndTypes.get(name)) instanceof DateType) {
                    value = (Serializable)type.decode((String)((Object)value));
                }
                row.put(name, value);
            }
            if (this.selectFieldsAndTypes.containsKey("ecm:fulltextScore")) {
                row.put("ecm:fulltextScore", Double.valueOf(hit.getScore()));
            }
            rows.add(row);
        }
        return rows;
    }

    public void close() {
        this.closed = true;
        this.pos = -1L;
    }

    public boolean isLife() {
        return !this.closed;
    }

    public boolean mustBeClosed() {
        return false;
    }

    public long size() {
        return this.response.getHits().getTotalHits();
    }

    public long pos() {
        return this.pos;
    }

    public void skipTo(long pos) {
        if (pos < 0L) {
            pos = 0L;
        } else if (pos > this.size) {
            pos = this.size;
        }
        this.pos = pos;
    }

    public Iterator<Map<String, Serializable>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.size;
    }

    @Override
    public Map<String, Serializable> next() {
        if (this.closed || this.pos == this.size) {
            throw new NoSuchElementException();
        }
        Map<String, Serializable> map = this.maps.get((int)this.pos);
        ++this.pos;
        return map;
    }
}

