/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRangeDate;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class DateHistogramAggregate
extends AggregateEsBase<BucketRangeDate> {
    Long intervalMillis;

    public DateHistogramAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public DateHistogramBuilder getEsAggregate() {
        DateHistogramBuilder ret = (DateHistogramBuilder)AggregationBuilders.dateHistogram((String)this.getId()).field(this.getField());
        Map props = this.getProperties();
        if (props.containsKey("interval")) {
            ret.interval(new DateHistogram.Interval((String)props.get("interval")));
        }
        if (props.containsKey("minDocCount")) {
            ret.minDocCount(Long.parseLong((String)props.get("minDocCount")));
        }
        if (props.containsKey("order")) {
            switch (((String)props.get("order")).toLowerCase()) {
                case "count desc": {
                    ret.order(Histogram.Order.COUNT_DESC);
                    break;
                }
                case "count asc": {
                    ret.order(Histogram.Order.COUNT_ASC);
                    break;
                }
                case "key desc": {
                    ret.order(Histogram.Order.KEY_DESC);
                    break;
                }
                case "key asc": {
                    ret.order(Histogram.Order.KEY_ASC);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid order: " + (String)props.get("order"));
                }
            }
        }
        if (props.containsKey("extendedBoundsMax") && props.containsKey("extendedBoundsMin")) {
            ret.extendedBounds((String)props.get("extendedBoundsMin"), (String)props.get("extendedBoundsMax"));
        }
        if (props.containsKey("timeZone")) {
            ret.timeZone((String)props.get("timeZone"));
        }
        if (props.containsKey("preZone")) {
            ret.timeZone((String)props.get("preZone"));
        }
        if (props.containsKey("format")) {
            ret.format((String)props.get("format"));
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public FilterBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        OrFilterBuilder ret = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
        for (String sel : this.getSelection()) {
            RangeFilterBuilder rangeFilter = FilterBuilders.rangeFilter((String)this.getField());
            long from = this.convertStringToDate(sel);
            long to = from + this.getIntervalInMillis();
            rangeFilter.gte(from).lt(to);
            ret.add((FilterBuilder)rangeFilter);
        }
        return ret;
    }

    private long convertStringToDate(String date) {
        Map props = this.getProperties();
        if (!props.containsKey("format")) {
            throw new IllegalArgumentException("format property must be defined for " + this.toString());
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)((String)props.get("format")));
        return fmt.parseDateTime(date).getMillis();
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketRangeDate> nxBuckets = new ArrayList<BucketRangeDate>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            DateHistogram.Bucket dateHistoBucket = (DateHistogram.Bucket)bucket;
            DateTime from = this.getDateTime(dateHistoBucket.getKeyAsDate());
            DateTime to = this.addInterval(from);
            nxBuckets.add(new BucketRangeDate(bucket.getKey(), from, to, dateHistoBucket.getDocCount()));
        }
        this.buckets = nxBuckets;
    }

    private DateTime addInterval(DateTime from) {
        return new DateTime(from.getMillis() + this.getIntervalInMillis());
    }

    public long getIntervalInMillis() {
        if (this.intervalMillis == null) {
            Map props = this.getProperties();
            if (!props.containsKey("interval")) {
                throw new IllegalArgumentException("interval property must be defined for " + this.toString());
            }
            String interval = (String)props.get("interval");
            interval = this.convertToTimeValueString(interval);
            this.intervalMillis = TimeValue.parseTimeValue((String)interval, null).getMillis();
        }
        return this.intervalMillis;
    }

    private String convertToTimeValueString(String interval) {
        switch (interval.toLowerCase()) {
            case "second": {
                return "1s";
            }
            case "minute": {
                return "1m";
            }
            case "hour": {
                return "1h";
            }
            case "day": {
                return "1d";
            }
            case "week": {
                return "7d";
            }
            case "year": {
                return "365d";
            }
            case "month": {
                return "30d";
            }
            case "quarter": {
                return "91d";
            }
        }
        return interval;
    }
}

