/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.VarRename;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorResultSet;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.InputStream;

public class Service {
    public static QueryIterator exec(OpService op, Context context) {
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        Op opRemote = VarRename.reverseRename(op.getSubOp(), true);
        Query query2 = OpAsQuery.asQuery(opRemote);
        Explain.explain("HTTP", query2, context);
        HttpQuery httpQuery = new HttpQuery(op.getService().getURI());
        httpQuery.addParam("query", query2.toString());
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        ResultSet rs = ResultSetFactory.fromXML(in);
        return new QueryIteratorResultSet(rs);
    }
}

