/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.features;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.context.ContextHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public class HTTPHelper
implements ContextHelper {
    protected static volatile ObjectMapper mapper = new ObjectMapper();
    private static final Integer TIMEOUT = 300000;

    public Blob call(String username, String password, String requestType, String path) throws IOException {
        return this.call(username, password, requestType, path, null, null, null, null);
    }

    public Blob call(String username, String password, String requestType, String path, Map<String, String> headers) throws IOException {
        return this.call(username, password, requestType, path, null, null, null, headers);
    }

    public Blob call(String username, String password, String requestType, String path, MultiPart mp) throws IOException {
        return this.call(username, password, requestType, path, null, null, mp, null);
    }

    public Blob call(String username, String password, String requestType, String path, MultiPart mp, Map<String, String> headers) throws IOException {
        return this.call(username, password, requestType, path, null, null, mp, headers);
    }

    public Blob call(String username, String password, String requestType, String path, MultivaluedMap<String, String> queryParams) throws IOException {
        return this.call(username, password, requestType, path, null, queryParams, null, null);
    }

    public Blob call(String username, String password, String requestType, String path, Object data) throws IOException {
        return this.call(username, password, requestType, path, data, null, null, null);
    }

    public Blob call(String username, String password, String requestType, String path, Object data, Map<String, String> headers) throws IOException {
        return this.call(username, password, requestType, path, data, null, null, headers);
    }

    public Blob call(String username, String password, String requestType, String url, Object data, MultivaluedMap<String, String> queryParams, MultiPart mp, Map<String, String> headers) throws IOException {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(MultiPartWriter.class);
        Client client = Client.create((ClientConfig)config);
        client.setConnectTimeout(TIMEOUT);
        client.setReadTimeout(TIMEOUT);
        if (username != null && password != null) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        }
        WebResource wr = client.resource(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            wr = wr.queryParams(queryParams);
        }
        WebResource.Builder builder = wr.accept(new String[]{"application/json"});
        if (mp != null) {
            builder = wr.type(MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (headers != null && !headers.isEmpty()) {
            for (String headerKey : headers.keySet()) {
                builder.header(headerKey, (Object)headers.get(headerKey));
            }
        }
        ClientResponse response = null;
        try {
            switch (requestType) {
                case "HEAD": 
                case "GET": {
                    response = (ClientResponse)builder.get(ClientResponse.class);
                    break;
                }
                case "POST": {
                    if (mp != null) {
                        response = (ClientResponse)builder.post(ClientResponse.class, (Object)mp);
                        break;
                    }
                    response = (ClientResponse)builder.post(ClientResponse.class, data);
                    break;
                }
                case "PUT": {
                    if (mp != null) {
                        response = (ClientResponse)builder.put(ClientResponse.class, (Object)mp);
                        break;
                    }
                    response = (ClientResponse)builder.put(ClientResponse.class, data);
                    break;
                }
                case "DELETE": {
                    response = (ClientResponse)builder.delete(ClientResponse.class, data);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (response != null && response.getStatus() >= 200 && response.getStatus() < 300) {
            return Blobs.createBlob((InputStream)response.getEntityInputStream());
        }
        return new StringBlob(response.getStatusInfo() != null ? response.getStatusInfo().toString() : "error");
    }
}

