/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.clients;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.DocumentModel;

@XObject(value="client")
public class OAuth2Client {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@id")
    protected String id;
    @XNode(value="@secret")
    protected String secret;
    @XNode(value="@enabled")
    protected boolean enabled = true;

    public OAuth2Client() {
    }

    public OAuth2Client(String name, String id, String secret) {
        this.name = name;
        this.id = id;
        this.secret = secret;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        doc.put("clientId", this.id);
        doc.put("clientSecret", this.secret);
        doc.put("name", this.name);
        doc.put("enabled", this.enabled);
        return doc;
    }

    static OAuth2Client fromDocumentModel(DocumentModel doc) {
        String name = (String)((Object)doc.getPropertyValue("oauth2Client:name"));
        String id = (String)((Object)doc.getPropertyValue("oauth2Client:clientId"));
        String secret = (String)((Object)doc.getPropertyValue("oauth2Client:clientSecret"));
        boolean enabled = (Boolean)doc.getPropertyValue("oauth2Client:enabled");
        OAuth2Client client = new OAuth2Client(name, id, secret);
        client.enabled = enabled;
        return client;
    }

    boolean isValidWith(String clientId, String clientSecret) {
        return this.enabled && this.id.equals(clientId) && (StringUtils.isEmpty((String)this.secret) || this.secret.equals(clientSecret));
    }
}

