/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.clients;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.clients.ClientRegistry;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ClientRegistryImpl
extends DefaultComponent
implements ClientRegistry {
    private static final Log log = LogFactory.getLog(ClientRegistry.class);

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        switch (extensionPoint) {
            case "clients": {
                OAuth2Client client = (OAuth2Client)contribution;
                this.registerClient(client);
                break;
            }
        }
    }

    @Override
    public boolean hasClient(String clientId) {
        DirectoryService service = this.getService();
        try (Session session = service.open("oauth2Clients");){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("clientId", clientId);
            DocumentModelList docs = session.query(filter);
            if (docs.size() == 0) {
                boolean bl = false;
                return bl;
            }
            DocumentModel entry = (DocumentModel)docs.get(0);
            boolean bl = OAuth2Client.fromDocumentModel(entry).isEnabled();
            return bl;
        }
    }

    @Override
    public boolean isValidClient(String clientId, String clientSecret) {
        DocumentModel docClient = this.getClientModel(clientId);
        if (docClient != null) {
            OAuth2Client client = OAuth2Client.fromDocumentModel(docClient);
            return client.isValidWith(clientId, clientSecret);
        }
        return false;
    }

    @Override
    public boolean registerClient(OAuth2Client client) {
        DocumentModel doc = this.getClientModel(client.getId());
        if (doc != null) {
            log.info((Object)"Trying to register an exisiting client");
            return false;
        }
        DirectoryService service = this.getService();
        try (Session session = service.open("oauth2Clients");){
            if (session.hasEntry(client.getId())) {
                log.debug((Object)String.format("ClientId is already registered: %s", client.getId()));
                boolean bl = false;
                return bl;
            }
            session.createEntry(client.toMap());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteClient(String clientId) {
        DirectoryService service = this.getService();
        try (Session session = service.open("oauth2Clients");){
            session.deleteEntry(clientId);
            boolean bl = true;
            return bl;
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    @Override
    public List<DocumentModel> listClients() {
        DirectoryService service = this.getService();
        try (Session session = service.open("oauth2Clients");){
            DocumentModelList documentModelList = session.getEntries();
            return documentModelList;
        }
    }

    @Override
    public OAuth2Client getClient(String clientId) {
        DocumentModel doc = this.getClientModel(clientId);
        return doc != null ? OAuth2Client.fromDocumentModel(doc) : null;
    }

    protected DocumentModel getClientModel(String clientId) {
        DirectoryService service = this.getService();
        try (Session session = service.open("oauth2Clients");){
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("clientId", clientId);
            DocumentModelList docs = session.query(filter);
            if (docs.size() > 0) {
                DocumentModel documentModel = (DocumentModel)docs.get(0);
                return documentModel;
            }
        }
        return null;
    }

    protected DirectoryService getService() {
        return (DirectoryService)Framework.getLocalService(DirectoryService.class);
    }
}

