/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptedPutObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.blob.AbstractBinaryGarbageCollector;
import org.nuxeo.ecm.blob.AbstractCloudBinaryManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;
import org.nuxeo.ecm.core.blob.binary.FileStorage;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.storage.sql.BasicAWSCredentialsProvider;

public class S3BinaryManager
extends AbstractCloudBinaryManager {
    private static final String MD5 = "MD5";
    private static final Log log = LogFactory.getLog(S3BinaryManager.class);
    public static final String SYSTEM_PROPERTY_PREFIX = "nuxeo.s3storage";
    public static final String BUCKET_NAME_PROPERTY = "bucket";
    public static final String BUCKET_PREFIX_PROPERTY = "bucket_prefix";
    public static final String BUCKET_REGION_PROPERTY = "region";
    public static final String DEFAULT_BUCKET_REGION = null;
    public static final String AWS_ID_PROPERTY = "awsid";
    public static final String AWS_ID_ENV = "AWS_ACCESS_KEY_ID";
    public static final String AWS_SECRET_PROPERTY = "awssecret";
    public static final String AWS_SECRET_ENV = "AWS_SECRET_ACCESS_KEY";
    public static final String CONNECTION_MAX_PROPERTY = "connection.max";
    public static final String CONNECTION_RETRY_PROPERTY = "connection.retry";
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connection.timeout";
    public static final String SOCKET_TIMEOUT_PROPERTY = "socket.timeout";
    public static final String KEYSTORE_FILE_PROPERTY = "crypt.keystore.file";
    public static final String KEYSTORE_PASS_PROPERTY = "crypt.keystore.password";
    public static final String SERVERSIDE_ENCRYPTION_PROPERTY = "crypt.serverside";
    public static final String PRIVKEY_ALIAS_PROPERTY = "crypt.key.alias";
    public static final String PRIVKEY_PASS_PROPERTY = "crypt.key.password";
    public static final String ENDPOINT_PROPERTY = "endpoint";
    public static final String DIRECTDOWNLOAD_PROPERTY_COMPAT = "downloadfroms3";
    public static final String DIRECTDOWNLOAD_EXPIRE_PROPERTY_COMPAT = "downloadfroms3.expire";
    private static final Pattern MD5_RE = Pattern.compile("(.*/)?[0-9a-f]{32}");
    protected String bucketName;
    protected String bucketNamePrefix;
    protected AWSCredentialsProvider awsCredentialsProvider;
    protected ClientConfiguration clientConfiguration;
    protected EncryptionMaterials encryptionMaterials;
    protected boolean isEncrypted;
    protected CryptoConfiguration cryptoConfiguration;
    protected boolean userServerSideEncryption;
    protected AmazonS3 amazonS3;
    protected TransferManager transferManager;

    protected String getDefaultDigestAlgorithm() {
        return MD5;
    }

    public void close() {
        this.transferManager.shutdownNow();
        super.close();
    }

    protected void abortOldUploads() throws IOException {
        int oneDay = 86400000;
        try {
            this.transferManager.abortMultipartUploads(this.bucketName, new Date(System.currentTimeMillis() - (long)oneDay));
        }
        catch (AmazonClientException e) {
            throw new IOException("Failed to abort old uploads", e);
        }
    }

    protected void setupCloudClient() throws IOException {
        int dde;
        this.bucketName = this.getProperty(BUCKET_NAME_PROPERTY);
        this.bucketNamePrefix = (String)MoreObjects.firstNonNull((Object)this.getProperty(BUCKET_PREFIX_PROPERTY), (Object)"");
        String bucketRegion = this.getProperty(BUCKET_REGION_PROPERTY);
        if (StringUtils.isBlank((String)bucketRegion)) {
            bucketRegion = DEFAULT_BUCKET_REGION;
        }
        String awsID = this.getProperty(AWS_ID_PROPERTY);
        String awsSecret = this.getProperty(AWS_SECRET_PROPERTY);
        String proxyHost = this.getProperty("nuxeo.http.proxy.host");
        String proxyPort = this.getProperty("nuxeo.http.proxy.port");
        String proxyLogin = this.getProperty("nuxeo.http.proxy.login");
        String proxyPassword = this.getProperty("nuxeo.http.proxy.password");
        int maxConnections = this.getIntProperty(CONNECTION_MAX_PROPERTY);
        int maxErrorRetry = this.getIntProperty(CONNECTION_RETRY_PROPERTY);
        int connectionTimeout = this.getIntProperty(CONNECTION_TIMEOUT_PROPERTY);
        int socketTimeout = this.getIntProperty(SOCKET_TIMEOUT_PROPERTY);
        String keystoreFile = this.getProperty(KEYSTORE_FILE_PROPERTY);
        String keystorePass = this.getProperty(KEYSTORE_PASS_PROPERTY);
        String privkeyAlias = this.getProperty(PRIVKEY_ALIAS_PROPERTY);
        String privkeyPass = this.getProperty(PRIVKEY_PASS_PROPERTY);
        String endpoint = this.getProperty(ENDPOINT_PROPERTY);
        String sseprop = this.getProperty(SERVERSIDE_ENCRYPTION_PROPERTY);
        if (StringUtils.isNotBlank((String)sseprop)) {
            this.userServerSideEncryption = Boolean.parseBoolean(sseprop);
        }
        if (StringUtils.isBlank((String)awsID)) {
            awsID = System.getenv(AWS_ID_ENV);
        }
        if (StringUtils.isBlank((String)awsSecret)) {
            awsSecret = System.getenv(AWS_SECRET_ENV);
        }
        if (StringUtils.isBlank((String)this.bucketName)) {
            throw new RuntimeException("Missing conf: bucket");
        }
        if (!StringUtils.isBlank((String)this.bucketNamePrefix) && !this.bucketNamePrefix.endsWith("/")) {
            log.warn((Object)String.format("%s %s S3 bucket prefix should end by '/' : added automatically.", BUCKET_PREFIX_PROPERTY, this.bucketNamePrefix));
            this.bucketNamePrefix = this.bucketNamePrefix + "/";
        }
        if (StringUtils.isBlank((String)awsID) || StringUtils.isBlank((String)awsSecret)) {
            this.awsCredentialsProvider = new InstanceProfileCredentialsProvider();
            try {
                this.awsCredentialsProvider.getCredentials();
            }
            catch (AmazonClientException e) {
                throw new RuntimeException("Missing AWS credentials and no instance role found");
            }
        } else {
            this.awsCredentialsProvider = new BasicAWSCredentialsProvider(awsID, awsSecret);
        }
        this.clientConfiguration = new ClientConfiguration();
        if (StringUtils.isNotBlank((String)proxyHost)) {
            this.clientConfiguration.setProxyHost(proxyHost);
        }
        if (StringUtils.isNotBlank((String)proxyPort)) {
            this.clientConfiguration.setProxyPort(Integer.parseInt(proxyPort));
        }
        if (StringUtils.isNotBlank((String)proxyLogin)) {
            this.clientConfiguration.setProxyUsername(proxyLogin);
        }
        if (proxyPassword != null) {
            this.clientConfiguration.setProxyPassword(proxyPassword);
        }
        if (maxConnections > 0) {
            this.clientConfiguration.setMaxConnections(maxConnections);
        }
        if (maxErrorRetry >= 0) {
            this.clientConfiguration.setMaxErrorRetry(maxErrorRetry);
        }
        if (connectionTimeout >= 0) {
            this.clientConfiguration.setConnectionTimeout(connectionTimeout);
        }
        if (socketTimeout >= 0) {
            this.clientConfiguration.setSocketTimeout(socketTimeout);
        }
        this.encryptionMaterials = null;
        if (StringUtils.isNotBlank((String)keystoreFile)) {
            boolean confok = true;
            if (keystorePass == null) {
                log.error((Object)"Keystore password missing");
                confok = false;
            }
            if (StringUtils.isBlank((String)privkeyAlias)) {
                log.error((Object)"Key alias missing");
                confok = false;
            }
            if (privkeyPass == null) {
                log.error((Object)"Key password missing");
                confok = false;
            }
            if (!confok) {
                throw new RuntimeException("S3 Crypto configuration incomplete");
            }
            try {
                File ksFile = new File(keystoreFile);
                FileInputStream ksStream = new FileInputStream(ksFile);
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(ksStream, keystorePass.toCharArray());
                ksStream.close();
                if (!keystore.isKeyEntry(privkeyAlias)) {
                    throw new RuntimeException("Alias " + privkeyAlias + " is missing or not a key alias");
                }
                PrivateKey privKey = (PrivateKey)keystore.getKey(privkeyAlias, privkeyPass.toCharArray());
                Certificate cert = keystore.getCertificate(privkeyAlias);
                PublicKey pubKey = cert.getPublicKey();
                KeyPair keypair = new KeyPair(pubKey, privKey);
                this.encryptionMaterials = new EncryptionMaterials(keypair);
                this.cryptoConfiguration = new CryptoConfiguration();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Could not read keystore: " + keystoreFile + ", alias: " + privkeyAlias, e);
            }
        }
        this.isEncrypted = this.encryptionMaterials != null;
        this.amazonS3 = !this.isEncrypted ? new AmazonS3Client(this.awsCredentialsProvider, this.clientConfiguration) : new AmazonS3EncryptionClient(this.awsCredentialsProvider, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(this.encryptionMaterials), this.clientConfiguration, this.cryptoConfiguration);
        if (StringUtils.isNotBlank((String)endpoint)) {
            this.amazonS3.setEndpoint(endpoint);
        }
        ArrayList<String> V4_ONLY_REGIONS = new ArrayList<String>();
        V4_ONLY_REGIONS.add("eu-central-1");
        V4_ONLY_REGIONS.add("ap-northeast-2");
        if (V4_ONLY_REGIONS.contains(bucketRegion)) {
            this.amazonS3.setRegion(Region.getRegion((Regions)Regions.fromName((String)bucketRegion)));
        }
        try {
            if (!this.amazonS3.doesBucketExist(this.bucketName)) {
                this.amazonS3.createBucket(this.bucketName, bucketRegion);
                this.amazonS3.setBucketAcl(this.bucketName, CannedAccessControlList.Private);
            }
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        String dd = this.getProperty(DIRECTDOWNLOAD_PROPERTY_COMPAT);
        if (dd != null) {
            this.directDownload = Boolean.parseBoolean(dd);
        }
        if ((dde = this.getIntProperty(DIRECTDOWNLOAD_EXPIRE_PROPERTY_COMPAT)) >= 0) {
            this.directDownloadExpire = dde;
        }
        this.transferManager = new TransferManager(this.amazonS3);
        this.abortOldUploads();
    }

    protected void removeBinary(String digest) {
        this.amazonS3.deleteObject(this.bucketName, digest);
    }

    protected String getSystemPropertyPrefix() {
        return SYSTEM_PROPERTY_PREFIX;
    }

    protected BinaryGarbageCollector instantiateGarbageCollector() {
        return new S3BinaryGarbageCollector(this);
    }

    public void removeBinaries(Collection<String> digests) {
        digests.forEach(this::removeBinary);
    }

    protected static boolean isMissingKey(AmazonClientException e) {
        if (e instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)e;
            return ase.getStatusCode() == 404 || "NoSuchKey".equals(ase.getErrorCode()) || "Not Found".equals(e.getMessage());
        }
        return false;
    }

    public static boolean isMD5(String digest) {
        return MD5_RE.matcher(digest).matches();
    }

    protected FileStorage getFileStorage() {
        return new S3FileStorage();
    }

    public Blob readBlob(BlobManager.BlobInfo blobInfo) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).readBlob(blobInfo);
    }

    public String writeBlob(Blob blob, Document doc) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).writeBlob(blob, doc);
    }

    protected boolean isDirectDownload() {
        return this.directDownload;
    }

    protected URI getRemoteUri(String digest, ManagedBlob blob, HttpServletRequest servletRequest) throws IOException {
        String key = this.bucketNamePrefix + digest;
        Date expiration = new Date();
        expiration.setTime(expiration.getTime() + (long)(this.directDownloadExpire * 1000));
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucketName, key, HttpMethod.GET);
        request.addRequestParameter("response-content-type", this.getContentTypeHeader((Blob)blob));
        request.addRequestParameter("response-content-disposition", this.getContentDispositionHeader((Blob)blob, servletRequest));
        request.setExpiration(expiration);
        URL url = this.amazonS3.generatePresignedUrl(request);
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static class S3BinaryGarbageCollector
    extends AbstractBinaryGarbageCollector<S3BinaryManager> {
        protected S3BinaryGarbageCollector(S3BinaryManager binaryManager) {
            super((CachingBinaryManager)binaryManager);
        }

        public String getId() {
            return "s3:" + ((S3BinaryManager)this.binaryManager).bucketName;
        }

        public Set<String> getUnmarkedBlobs() {
            HashSet<String> unmarked = new HashSet<String>();
            ObjectListing list = null;
            do {
                list = list == null ? ((S3BinaryManager)this.binaryManager).amazonS3.listObjects(((S3BinaryManager)this.binaryManager).bucketName, ((S3BinaryManager)this.binaryManager).bucketNamePrefix) : ((S3BinaryManager)this.binaryManager).amazonS3.listNextBatchOfObjects(list);
                for (S3ObjectSummary summary : list.getObjectSummaries()) {
                    String digest = summary.getKey();
                    if (!S3BinaryManager.isMD5(digest)) continue;
                    long length = summary.getSize();
                    if (this.marked.contains(digest)) {
                        ++this.status.numBinaries;
                        this.status.sizeBinaries += length;
                        continue;
                    }
                    ++this.status.numBinariesGC;
                    this.status.sizeBinariesGC += length;
                    unmarked.add(digest);
                    this.marked.remove(digest);
                }
            } while (list.isTruncated());
            return unmarked;
        }
    }

    public class S3FileStorage
    implements FileStorage {
        public void storeFile(String digest, File file) throws IOException {
            String etag;
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("storing blob " + digest + " to S3"));
            }
            String key = S3BinaryManager.this.bucketNamePrefix + digest;
            try {
                ObjectMetadata metadata = S3BinaryManager.this.amazonS3.getObjectMetadata(S3BinaryManager.this.bucketName, key);
                etag = metadata.getETag();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("blob " + digest + " is already in S3"));
                }
            }
            catch (AmazonClientException e) {
                PutObjectRequest request;
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                if (!S3BinaryManager.this.isEncrypted) {
                    request = new PutObjectRequest(S3BinaryManager.this.bucketName, key, file);
                    if (S3BinaryManager.this.userServerSideEncryption) {
                        ObjectMetadata objectMetadata = new ObjectMetadata();
                        objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                        request.setMetadata(objectMetadata);
                    }
                } else {
                    request = new EncryptedPutObjectRequest(S3BinaryManager.this.bucketName, key, file);
                }
                Upload upload = S3BinaryManager.this.transferManager.upload(request);
                try {
                    UploadResult result = upload.waitForUploadResult();
                    etag = result.getETag();
                }
                catch (AmazonClientException ee) {
                    throw new IOException(ee);
                }
                catch (InterruptedException ee) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ee);
                }
                finally {
                    if (log.isDebugEnabled()) {
                        long dtms = System.currentTimeMillis() - t0;
                        log.debug((Object)("stored blob " + digest + " to S3 in " + dtms + "ms"));
                    }
                }
            }
            if (!(S3BinaryManager.this.isEncrypted || etag.equals(digest) || ServiceUtils.isMultipartUploadETag((String)etag))) {
                throw new IOException("Invalid ETag in S3, ETag=" + etag + " digest=" + digest);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fetchFile(String digest, File file) throws IOException {
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("fetching blob " + digest + " from S3"));
            }
            try {
                ObjectMetadata metadata = S3BinaryManager.this.amazonS3.getObject(new GetObjectRequest(S3BinaryManager.this.bucketName, S3BinaryManager.this.bucketNamePrefix + digest), file);
                String etag = metadata.getETag();
                if (!(S3BinaryManager.this.isEncrypted || etag.equals(digest) || ServiceUtils.isMultipartUploadETag((String)etag))) {
                    log.error((Object)("Invalid ETag in S3, ETag=" + etag + " digest=" + digest));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (AmazonClientException e) {
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (log.isDebugEnabled()) {
                    long dtms = System.currentTimeMillis() - t0;
                    log.debug((Object)("fetched blob " + digest + " from S3 in " + dtms + "ms"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long fetchLength(String digest) throws IOException {
            long t0 = 0L;
            if (log.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
                log.debug((Object)("fetching blob length " + digest + " from S3"));
            }
            try {
                ObjectMetadata metadata = S3BinaryManager.this.amazonS3.getObjectMetadata(S3BinaryManager.this.bucketName, S3BinaryManager.this.bucketNamePrefix + digest);
                String etag = metadata.getETag();
                if (!(S3BinaryManager.this.isEncrypted || etag.equals(digest) || ServiceUtils.isMultipartUploadETag((String)etag))) {
                    log.error((Object)("Invalid ETag in S3, ETag=" + etag + " digest=" + digest));
                    Long l = null;
                    return l;
                }
                Long l = metadata.getContentLength();
                return l;
            }
            catch (AmazonClientException e) {
                if (!S3BinaryManager.isMissingKey(e)) {
                    throw new IOException(e);
                }
                Long l = null;
                return l;
            }
            finally {
                if (log.isDebugEnabled()) {
                    long dtms = System.currentTimeMillis() - t0;
                    log.debug((Object)("fetched blob length " + digest + " from S3 in " + dtms + "ms"));
                }
            }
        }
    }
}

