/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.security;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.security.DefaultPermission;
import org.nuxeo.ecm.webengine.security.Guard;
import org.nuxeo.ecm.webengine.security.GuardFactory;
import org.nuxeo.ecm.webengine.security.Permission;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.ecm.webengine.security.guards.And;
import org.nuxeo.ecm.webengine.security.guards.FacetGuard;
import org.nuxeo.ecm.webengine.security.guards.GroupGuard;
import org.nuxeo.ecm.webengine.security.guards.IsAdministratorGuard;
import org.nuxeo.ecm.webengine.security.guards.PermissionGuard;
import org.nuxeo.ecm.webengine.security.guards.SchemaGuard;
import org.nuxeo.ecm.webengine.security.guards.ScriptGuard;
import org.nuxeo.ecm.webengine.security.guards.TypeGuard;
import org.nuxeo.ecm.webengine.security.guards.UserGuard;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@XObject(value="permission")
public class GuardDescriptor {
    private static final Log log = LogFactory.getLog(GuardDescriptor.class);
    @XNode(value="@id")
    protected String id;
    @XNode(value="@expression")
    protected String expression;
    protected Map<String, Guard> guards;

    public GuardDescriptor() {
        this(null);
    }

    public GuardDescriptor(String name) {
        this.id = name;
        this.guards = new HashMap<String, Guard>();
    }

    public Map<String, Guard> getGuards() {
        return this.guards;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    @XContent
    protected void setGuards(DocumentFragment content) {
        for (Node node = content.getFirstChild(); node != null; node = node.getNextSibling()) {
            String value;
            String name;
            if (node.getNodeType() != 1 || !"guard".equals(name = node.getNodeName())) continue;
            NamedNodeMap map = node.getAttributes();
            Node aId = map.getNamedItem("id");
            Node aType = map.getNamedItem("type");
            if (aId == null) {
                throw new IllegalArgumentException("id is required");
            }
            String id = aId.getNodeValue();
            if (aType == null) {
                throw new IllegalArgumentException("type is required");
            }
            String type = aType.getNodeValue();
            if ("permission".equals(type)) {
                value = node.getTextContent().trim();
                this.guards.put(id, new PermissionGuard(value));
                continue;
            }
            if ("isAdministrator".equals(type)) {
                value = node.getTextContent().trim();
                this.guards.put(id, new IsAdministratorGuard(value));
                continue;
            }
            if ("facet".equals(type)) {
                value = node.getTextContent().trim();
                this.guards.put(id, new FacetGuard(value));
                continue;
            }
            if ("type".equals(type)) {
                value = node.getTextContent().trim();
                this.guards.put(id, new TypeGuard(value));
                continue;
            }
            if ("schema".equals(type)) {
                value = node.getTextContent().trim();
                this.guards.put(id, new SchemaGuard(value));
                continue;
            }
            if ("user".equals(type)) {
                value = node.getTextContent().trim();
                this.guards.put(id, new UserGuard(value));
                continue;
            }
            if ("group".equals(type)) {
                value = node.getTextContent().trim();
                this.guards.put(id, new GroupGuard(value));
                continue;
            }
            if ("script".equals(type)) {
                Node engineNode = map.getNamedItem("engine");
                if (engineNode == null) {
                    throw new IllegalArgumentException("Must specify an engine attribute on script guards");
                }
                String value2 = node.getTextContent().trim();
                this.guards.put(id, new ScriptGuard(engineNode.getNodeValue(), value2));
                continue;
            }
            if ("expression".equals(type)) {
                value = node.getTextContent().trim();
                try {
                    this.guards.put(id, PermissionService.getInstance().parse(value, this.guards));
                }
                catch (ParseException e) {
                    log.error((Object)e, (Throwable)e);
                }
                continue;
            }
            value = node.getTextContent().trim();
            try {
                Class<?> factory = Class.forName(type);
                Guard guard = ((GuardFactory)factory.newInstance()).newGuard(value);
                this.guards.put(id, guard);
                continue;
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public Guard getGuard() throws ParseException {
        if (this.expression == null || this.expression.length() == 0) {
            return new And(this.guards.values());
        }
        return PermissionService.getInstance().parse(this.expression, this.guards);
    }

    public String getId() {
        return this.id;
    }

    public Permission getPermission() throws ParseException {
        return new DefaultPermission(this.id, this.getGuard());
    }
}

