/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.install;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.install.AppendOperation;
import org.nuxeo.ecm.webengine.install.CopyOperation;
import org.nuxeo.ecm.webengine.model.exceptions.WebDeployException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RuntimeContext;
import org.osgi.framework.Bundle;

@XObject(value="install")
public class Installer {
    private static final Log log = LogFactory.getLog(Installer.class);
    @XNode(value="@module")
    public String module;
    @XNodeList(value="copy", type=ArrayList.class, componentType=CopyOperation.class)
    private List<CopyOperation> copyOperations;
    @XNodeList(value="append", type=ArrayList.class, componentType=AppendOperation.class)
    private List<AppendOperation> appendOperations;
    protected RuntimeContext ctx;

    public Bundle getBundle() {
        return this.ctx.getBundle();
    }

    public RuntimeContext getContext() {
        return this.ctx;
    }

    public void logError(String message, Throwable t) {
        log.error((Object)message, t);
    }

    public void logError(String message) {
        log.error((Object)message);
    }

    public void logInfo(String message) {
        log.error((Object)message);
    }

    public void logWarning(String message) {
        log.error((Object)message);
    }

    public void logTrace(String message) {
        log.error((Object)message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(RuntimeContext ctx, File installDir) {
        this.ctx = ctx;
        if (this.module != null && new File(installDir, this.module).exists()) {
            return;
        }
        boolean deleteDir = false;
        File bundleDir = null;
        try {
            Bundle bundle = ctx.getBundle();
            File file = this.getBundleFile(bundle);
            if (file == null) {
                throw new IOException("Couldn't transform the bundle location into a file " + bundle);
            }
            if (file.isDirectory()) {
                bundleDir = file;
            } else {
                deleteDir = true;
                bundleDir = this.getTempBundleDir(bundle);
                ZipUtils.unzip((File)file, (File)bundleDir);
            }
            if (this.copyOperations != null) {
                for (CopyOperation copy : this.copyOperations) {
                    copy.run(this, bundleDir, installDir);
                }
            }
            if (this.appendOperations != null) {
                for (AppendOperation append : this.appendOperations) {
                    append.run(this, bundleDir, installDir);
                }
            }
            if (!deleteDir || bundleDir == null) return;
        }
        catch (IOException e) {
            try {
                throw new WebDeployException("Installation failed for bundle: " + ctx.getBundle().getSymbolicName(), e);
            }
            catch (Throwable throwable) {
                if (!deleteDir || bundleDir == null) throw throwable;
                FileUtils.deleteTree(bundleDir);
                throw throwable;
            }
        }
        FileUtils.deleteTree((File)bundleDir);
        return;
    }

    public void uninstall(RuntimeContext ctx, File installDir) {
    }

    public static void copyResources(Bundle bundle, String path, File root) throws IOException {
        File file = Framework.getRuntime().getBundleFile(bundle);
        if (file == null) {
            throw new UnsupportedOperationException("Couldn't transform the bundle location into a file");
        }
        root.mkdirs();
        if (file.isDirectory()) {
            file = new File(file, path);
            FileUtils.copy((File[])file.listFiles(), (File)root);
        } else {
            ZipUtils.unzip((String)path, (File)file, (File)root);
        }
    }

    protected File getTempBundleDir(Bundle bundle) {
        return new File(Framework.getRuntime().getHome(), "tmp/bundles/" + bundle.getSymbolicName());
    }

    protected File getBundleFile(Bundle bundle) {
        return Framework.getRuntime().getBundleFile(bundle);
    }
}

