/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import java.io.IOException;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Schema;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class FacetJsonWriter
extends ExtensibleEntityJsonWriter<CompositeType> {
    public static final String ENTITY_TYPE = "facet";

    public FacetJsonWriter() {
        super(ENTITY_TYPE, CompositeType.class);
    }

    @Override
    protected void writeEntityBody(CompositeType facet, JsonGenerator jg) throws IOException {
        jg.writeStringField("name", facet.getName());
        if (facet.getSchemaNames() != null && facet.getSchemaNames().length > 0) {
            jg.writeArrayFieldStart("schemas");
            Writer<Schema> schemaWriter = this.registry.getWriter(this.ctx, Schema.class, MediaType.APPLICATION_JSON_TYPE);
            for (Schema schema : facet.getSchemas()) {
                OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                schemaWriter.write(schema, Schema.class, (Type)((Object)Schema.class), MediaType.APPLICATION_JSON_TYPE, out);
            }
            jg.writeEndArray();
        }
    }
}

