/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsAnything;
import org.jmock.api.Action;
import org.jmock.api.Expectation;
import org.jmock.api.Invocation;
import org.jmock.internal.Cardinality;
import org.jmock.internal.Formatting;
import org.jmock.internal.OrderingConstraint;
import org.jmock.internal.SideEffect;
import org.jmock.lib.action.VoidAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationExpectation
implements Expectation {
    private Cardinality cardinality = Cardinality.ALLOWING;
    private Matcher<?> objectMatcher = IsAnything.anything();
    private Matcher<Method> methodMatcher = IsAnything.anything((String)"<any method>");
    private Matcher<Object[]> parametersMatcher = IsAnything.anything((String)"(<any parameters>)");
    private Action action = new VoidAction();
    private List<OrderingConstraint> orderingConstraints = new ArrayList<OrderingConstraint>();
    private List<SideEffect> sideEffects = new ArrayList<SideEffect>();
    private int invocationCount = 0;

    public void setCardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    public void setObjectMatcher(Matcher<?> objectMatcher) {
        this.objectMatcher = objectMatcher;
    }

    public void setMethodMatcher(Matcher<Method> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    public void setParametersMatcher(Matcher<Object[]> parametersMatcher) {
        this.parametersMatcher = parametersMatcher;
    }

    public void addOrderingConstraint(OrderingConstraint orderingConstraint) {
        this.orderingConstraints.add(orderingConstraint);
    }

    public void addSideEffect(SideEffect sideEffect) {
        this.sideEffects.add(sideEffect);
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void describeTo(Description description) {
        this.cardinality.describeTo(description);
        description.appendText(", ");
        if (this.invocationCount == 0) {
            description.appendText("never invoked");
        } else {
            description.appendText("already invoked ");
            description.appendText(Formatting.times(this.invocationCount));
        }
        description.appendText(": ");
        this.objectMatcher.describeTo(description);
        description.appendText(".");
        this.methodMatcher.describeTo(description);
        this.parametersMatcher.describeTo(description);
        for (OrderingConstraint orderingConstraint : this.orderingConstraints) {
            description.appendText("; ");
            orderingConstraint.describeTo(description);
        }
        description.appendText("; ");
        this.action.describeTo(description);
        for (SideEffect sideEffect : this.sideEffects) {
            description.appendText("; ");
            sideEffect.describeTo(description);
        }
    }

    @Override
    public boolean isSatisfied() {
        return this.cardinality.isSatisfied(this.invocationCount);
    }

    @Override
    public boolean allowsMoreInvocations() {
        return this.cardinality.allowsMoreInvocations(this.invocationCount);
    }

    @Override
    public boolean matches(Invocation invocation) {
        return this.allowsMoreInvocations() && this.objectMatcher.matches(invocation.getInvokedObject()) && this.methodMatcher.matches((Object)invocation.getInvokedMethod()) && this.parametersMatcher.matches((Object)invocation.getParametersAsArray()) && this.isInCorrectOrder();
    }

    private boolean isInCorrectOrder() {
        for (OrderingConstraint constraint : this.orderingConstraints) {
            if (constraint.allowsInvocationNow()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        ++this.invocationCount;
        this.performSideEffects();
        Object result = this.action.invoke(invocation);
        invocation.checkReturnTypeCompatibility(result);
        return result;
    }

    private void performSideEffects() {
        for (SideEffect sideEffect : this.sideEffects) {
            sideEffect.perform();
        }
    }
}

