/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.service.impl;

import java.util.Arrays;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.NodeDetail;
import org.w3c.dom.Node;

public class IgnoreStructuralDifferenceListener
implements DifferenceListener {
    private static final String SCHEMA_ELEMENT = "schema";
    private static final int[] IGNORE = new int[]{21, 7, 8, 9, 16, 3, 2, 10, 20, 19};

    public int differenceFound(Difference difference) {
        boolean unBalancedSchema = false;
        NodeDetail controlNodeDetail = difference.getControlNodeDetail();
        NodeDetail testNodeDetail = difference.getTestNodeDetail();
        if (controlNodeDetail != null && testNodeDetail != null) {
            Node controlNode = controlNodeDetail.getNode();
            Node testNode = testNodeDetail.getNode();
            if (controlNode != null && SCHEMA_ELEMENT.equals(controlNode.getNodeName()) && testNode == null) {
                unBalancedSchema = true;
            }
            if (!unBalancedSchema && testNode != null && SCHEMA_ELEMENT.equals(testNode.getNodeName()) && controlNode == null) {
                unBalancedSchema = true;
            }
        }
        return Arrays.binarySearch(IGNORE, difference.getId()) >= 0 || unBalancedSchema ? 1 : 0;
    }

    public void skippedComparison(Node control, Node test) {
    }

    static {
        Arrays.sort(IGNORE);
    }
}

