/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.imaging.recompute;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.imaging.recompute.ImagingRecomputeWork;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="imagingRecomputeActions")
@Scope(value=ScopeType.CONVERSATION)
public class ImagingRecomputeActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NXQL_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Picture' AND picture:views/*/title IS NULL";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    protected String nxqlQuery = "SELECT * FROM Document WHERE ecm:mixinType = 'Picture' AND picture:views/*/title IS NULL";

    public String getNxqlQuery() {
        return this.nxqlQuery;
    }

    public void setNxqlQuery(String nxqlQuery) {
        this.nxqlQuery = nxqlQuery;
    }

    public void recomputePictureViews() {
        this.recomputePictureViews(this.navigationContext.getCurrentDocument());
    }

    public void recomputePictureViews(DocumentModel doc) {
        if (doc.hasFacet("Picture")) {
            BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (blobHolder.getBlob() != null) {
                blobHolder.setBlob(blobHolder.getBlob());
                Events.instance().raiseEvent("beforeDocumentChanged", new Object[]{doc});
                this.documentManager.saveDocument(doc);
                this.documentManager.save();
                this.navigationContext.invalidateCurrentDocument();
            }
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, "label.imaging.recompute.views.done", new Object[0]);
        }
    }

    public void launchPictureViewsRecomputation() {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        if (workManager == null) {
            throw new RuntimeException("No WorkManager available");
        }
        if (!StringUtils.isBlank((String)this.nxqlQuery)) {
            ImagingRecomputeWork work = new ImagingRecomputeWork(this.documentManager.getRepositoryName(), this.nxqlQuery);
            workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, "label.imaging.recompute.work.launched", new Object[0]);
        }
    }
}

