/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;

public class JDBCLogger {
    public static final Log log = LogFactory.getLog(JDBCLogger.class);
    public static final int DEBUG_MAX_STRING = 100;
    public static final int DEBUG_MAX_ARRAY = 10;
    public final String instance;
    private static final String CALLABLE_START = "{?=";

    public JDBCLogger(String instance) {
        this.instance = instance;
    }

    public boolean isLogEnabled() {
        return log.isTraceEnabled();
    }

    public String formatMessage(String message) {
        return "(" + this.instance + ") SQL: " + message;
    }

    public void error(String message) {
        log.error((Object)this.formatMessage(message));
    }

    public void error(String message, Throwable t) {
        log.error((Object)this.formatMessage(message), t);
    }

    public void warn(String message) {
        log.warn((Object)this.formatMessage(message));
    }

    public void info(String message) {
        log.info((Object)this.formatMessage(message));
    }

    public void log(String message) {
        log.trace((Object)this.formatMessage(message));
    }

    public void logCount(int count) {
        if (count > 0 && this.isLogEnabled()) {
            this.log("  -> " + count + " row" + (count > 1 ? "s" : ""));
        }
    }

    public void logCounts(int[] counts) {
        if (!this.isLogEnabled()) {
            return;
        }
        int count = 0;
        for (int c : counts) {
            count += c;
        }
        this.logCount(count);
    }

    public void logResultSet(ResultSet rs, List<Column> columns) throws SQLException {
        LinkedList<String> res = new LinkedList<String>();
        int i = 0;
        for (Column column : columns) {
            Serializable v = column.getFromResultSet(rs, ++i);
            res.add(column.getKey() + "=" + JDBCLogger.loggedValue(v));
        }
        this.log("  -> " + StringUtils.join(res, (String)", "));
    }

    public void logMap(Map<String, Serializable> map) throws SQLException {
        LinkedList<String> res = new LinkedList<String>();
        for (Map.Entry<String, Serializable> en : map.entrySet()) {
            res.add(en.getKey() + "=" + JDBCLogger.loggedValue(en.getValue()));
        }
        this.log("  -> " + StringUtils.join(res, (String)", "));
    }

    public void logIds(List<Serializable> ids, boolean countTotal, long totalSize) {
        List<Serializable> debugIds = ids;
        String end = "";
        if (ids.size() > 10) {
            debugIds = new ArrayList<Serializable>(10);
            int i = 0;
            for (Serializable id : ids) {
                debugIds.add(id);
                if (++i != 10) continue;
                break;
            }
            end = "...(" + ids.size() + " ids)...";
        }
        if (countTotal) {
            end = end + " (total " + totalSize + ')';
        }
        this.log("  -> " + debugIds + end);
    }

    public void logSQL(String sql, List<Column> columns, Row row) {
        this.logSQL(sql, columns, row, Collections.emptySet());
    }

    public void logSQL(String sql, List<Column> columns, Row row, Set<String> deltas) {
        ArrayList<Serializable> values = new ArrayList<Serializable>(columns.size());
        for (Column column : columns) {
            String key = column.getKey();
            Serializable value = row.get(key);
            if (deltas.contains(key)) {
                value = ((Delta)value).getDeltaValue();
            }
            values.add(value);
        }
        this.logSQL(sql, values);
    }

    public void logSQL(String sql, Collection<Serializable> values) {
        StringBuilder buf = new StringBuilder();
        int start = 0;
        if (sql.startsWith(CALLABLE_START)) {
            buf.append(CALLABLE_START);
            start = CALLABLE_START.length();
        }
        for (Serializable v : values) {
            int index = sql.indexOf(63, start);
            if (index == -1) break;
            buf.append(sql, start, index);
            buf.append(JDBCLogger.loggedValue(v));
            start = index + 1;
        }
        buf.append(sql, start, sql.length());
        this.log(buf.toString());
    }

    public static String loggedValue(Object value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof String) {
            String v = (String)value;
            if (v.length() > 100) {
                v = v.substring(0, 100) + "...(" + v.length() + " chars)...";
            }
            return "'" + v.replace("'", "''") + "'";
        }
        if (value instanceof Calendar) {
            char sign;
            Calendar cal = (Calendar)value;
            int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            return String.format("TIMESTAMP '%04d-%02d-%02dT%02d:%02d:%02d.%03d%c%02d:%02d'", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), Character.valueOf(sign), offset / 60, offset % 60);
        }
        if (value instanceof Date) {
            return "DATE '" + value.toString() + "'";
        }
        if (value instanceof Object[]) {
            Object[] v = (Object[])value;
            StringBuilder b = new StringBuilder();
            b.append('[');
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    b.append(',');
                    if (i > 10) {
                        b.append("...(" + v.length + " items)...");
                        break;
                    }
                }
                b.append(JDBCLogger.loggedValue(v[i]));
            }
            b.append(']');
            return b.toString();
        }
        return value.toString();
    }
}

