/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.JDBCUtils;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.XAResourceConnectionAdapter;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;

public class JDBCConnection {
    private static final Log log = LogFactory.getLog(JDBCConnection.class);
    private static final String APPLICATION_NAME = "ApplicationName";
    private static final String SET_CLIENT_INFO_PROP = "org.nuxeo.vcs.setClientInfo";
    private static final String SET_CLIENT_INFO_DEFAULT = "false";
    protected final Model model;
    protected final SQLInfo sqlInfo;
    protected final Dialect dialect;
    protected final XADataSource xadatasource;
    private XAConnection xaconnection;
    public Connection connection;
    protected boolean supportsBatchUpdates;
    protected XAResource xaresource = new XAResourceConnectionAdapter(this);
    protected final boolean noSharing;
    public boolean countExecutes;
    public int executeCount;
    private static final AtomicLong instanceCounter = new AtomicLong(0L);
    private final long instanceNumber = instanceCounter.incrementAndGet();
    public final JDBCLogger logger = new JDBCLogger(String.valueOf(this.instanceNumber));
    protected boolean setClientInfo;

    public JDBCConnection(Model model, SQLInfo sqlInfo, XADataSource xadatasource, boolean noSharing) {
        this.model = model;
        this.sqlInfo = sqlInfo;
        this.xadatasource = xadatasource;
        this.noSharing = noSharing;
        this.dialect = sqlInfo.dialect;
        this.setClientInfo = Boolean.parseBoolean(Framework.getProperty((String)SET_CLIENT_INFO_PROP, (String)SET_CLIENT_INFO_DEFAULT));
    }

    public JDBCConnection() {
        this.xadatasource = null;
        this.sqlInfo = null;
        this.noSharing = false;
        this.model = null;
        this.dialect = null;
    }

    public String getRepositoryName() {
        return this.model.getRepositoryDescriptor().name;
    }

    public Mapper.Identification getIdentification() {
        return new Mapper.Identification(null, "" + this.instanceNumber);
    }

    protected void countExecute() {
        if (this.countExecutes) {
            ++this.executeCount;
        }
    }

    protected void openConnections() {
        try {
            this.openBaseConnection();
            this.supportsBatchUpdates = this.connection.getMetaData().supportsBatchUpdates();
            this.dialect.performPostOpenStatements(this.connection);
        }
        catch (SQLException cause) {
            throw new NuxeoException("Cannot connect to database: " + this.getRepositoryName(), (Throwable)cause);
        }
    }

    protected void openBaseConnection() throws SQLException {
        String dataSourceName = ConnectionHelper.getPseudoDataSourceNameForRepository((String)this.getRepositoryName());
        this.connection = ConnectionHelper.getConnection((String)dataSourceName, (boolean)this.noSharing);
        if (this.connection == null) {
            this.xaconnection = JDBCUtils.getXAConnection((XADataSource)this.xadatasource);
            this.connection = this.xaconnection.getConnection();
            this.xaresource = this.xaconnection.getXAResource();
        } else {
            this.xaconnection = null;
        }
        if (this.setClientInfo) {
            this.connection.setClientInfo(APPLICATION_NAME, "nuxeo m=" + this.instanceNumber);
        }
    }

    public void close() {
        this.closeConnections();
    }

    public void closeConnections() {
        if (this.connection != null) {
            try {
                try {
                    if (this.setClientInfo) {
                        this.connection.setClientInfo(APPLICATION_NAME, "nuxeo");
                    }
                }
                finally {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
        if (this.xaconnection != null) {
            try {
                this.xaconnection.close();
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            finally {
                this.xaconnection = null;
            }
        }
    }

    protected void checkConcurrentUpdate(Throwable e) throws ConcurrentUpdateException {
        if (this.dialect.isConcurrentUpdateException(e)) {
            throw new ConcurrentUpdateException(e);
        }
    }

    protected void closeStatement(Statement s) throws SQLException {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void closeStatement(Statement s, ResultSet r) throws SQLException {
        try {
            if (r != null) {
                r.close();
            }
            if (s != null) {
                s.close();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

