/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.jdbc.CollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;

public class ACLCollectionIO
implements CollectionIO {
    public static final CollectionIO INSTANCE = new ACLCollectionIO();

    @Override
    public ACLRow getCurrentFromResultSet(ResultSet rs, List<Column> columns, Model model, Serializable[] returnId, int[] returnPos) throws SQLException {
        int pos;
        Object id = null;
        String name = null;
        boolean grant = false;
        String permission = null;
        String creator = null;
        Calendar begin = null;
        Calendar end = null;
        String user = null;
        String group = null;
        Long status = null;
        int i = 0;
        block26: for (Column column : columns) {
            String key = column.getKey();
            Serializable v = column.getFromResultSet(rs, ++i);
            switch (key) {
                case "id": {
                    id = v;
                    continue block26;
                }
                case "name": {
                    name = (String)((Object)v);
                    continue block26;
                }
                case "grant": {
                    grant = v == null ? false : (Boolean)v;
                    continue block26;
                }
                case "permission": {
                    permission = (String)((Object)v);
                    continue block26;
                }
                case "creator": {
                    creator = (String)((Object)v);
                    continue block26;
                }
                case "begin": {
                    begin = (Calendar)v;
                    continue block26;
                }
                case "end": {
                    end = (Calendar)v;
                    continue block26;
                }
                case "user": {
                    user = (String)((Object)v);
                    continue block26;
                }
                case "group": {
                    group = (String)((Object)v);
                    continue block26;
                }
                case "status": {
                    status = (Long)v;
                    continue block26;
                }
                case "pos": {
                    continue block26;
                }
            }
            throw new RuntimeException(key);
        }
        Serializable prevId = returnId[0];
        returnId[0] = id;
        returnPos[0] = pos = id != null && !id.equals(prevId) ? 0 : returnPos[0] + 1;
        return new ACLRow(pos, name, grant, permission, user, group, creator, begin, end, status);
    }

    @Override
    public void executeInserts(PreparedStatement ps, List<Row> rows, List<Column> columns, boolean supportsBatchUpdates, String sql, JDBCConnection connection) throws SQLException {
        ArrayList<Serializable> debugValues = connection.logger.isLogEnabled() ? new ArrayList<Serializable>() : null;
        String loggedSql = supportsBatchUpdates ? sql + " -- BATCHED" : sql;
        int batch = 0;
        for (Row row : rows) {
            ++batch;
            Serializable id = row.id;
            Serializable[] array = row.values;
            for (int i = 0; i < array.length; ++i) {
                ACLRow acl = (ACLRow)array[i];
                int n = 0;
                for (Column column : columns) {
                    Object v;
                    String key;
                    ++n;
                    switch (key = column.getKey()) {
                        case "id": {
                            v = id;
                            break;
                        }
                        case "pos": {
                            v = (long)acl.pos;
                            break;
                        }
                        case "name": {
                            v = acl.name;
                            break;
                        }
                        case "grant": {
                            v = acl.grant;
                            break;
                        }
                        case "permission": {
                            v = acl.permission;
                            break;
                        }
                        case "creator": {
                            v = acl.creator;
                            break;
                        }
                        case "begin": {
                            v = acl.begin;
                            break;
                        }
                        case "end": {
                            v = acl.end;
                            break;
                        }
                        case "status": {
                            v = acl.status;
                            break;
                        }
                        case "user": {
                            v = acl.user;
                            break;
                        }
                        case "group": {
                            v = acl.group;
                            break;
                        }
                        default: {
                            throw new RuntimeException(key);
                        }
                    }
                    column.setToPreparedStatement(ps, n, (Serializable)v);
                    if (debugValues == null) continue;
                    debugValues.add((Serializable)v);
                }
                if (debugValues != null) {
                    connection.logger.logSQL(loggedSql, debugValues);
                    debugValues.clear();
                }
                if (supportsBatchUpdates) {
                    ps.addBatch();
                    if (batch % 100 != 0) continue;
                    ps.executeBatch();
                    connection.countExecute();
                    continue;
                }
                ps.execute();
                connection.countExecute();
            }
        }
        if (supportsBatchUpdates) {
            ps.executeBatch();
            connection.countExecute();
        }
    }
}

