/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Arrays;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Row;

public class CollectionFragment
extends Fragment {
    private static final long serialVersionUID = 1L;

    public CollectionFragment(Row row, Fragment.State state, PersistenceContext context) {
        super(row, state, context);
    }

    public void set(Serializable[] value) {
        if (this.getState() != Fragment.State.INVALIDATED_MODIFIED && Arrays.equals(this.row.values, value)) {
            return;
        }
        this.row.values = (Serializable[])value.clone();
        this.markModified();
    }

    public Serializable[] get() {
        this.accessed();
        return (Serializable[])this.row.values.clone();
    }

    public boolean isDirty() {
        return !Arrays.equals(this.row.values, this.oldvalues);
    }

    @Override
    protected Fragment.State refetch() {
        this.row.values = this.context.mapper.readCollectionRowArray(this.row);
        this.clearDirty();
        return Fragment.State.PRISTINE;
    }

    @Override
    protected Fragment.State refetchDeleted() {
        this.row.values = this.context.model.getCollectionFragmentType(this.row.tableName).getEmptyArray();
        this.clearDirty();
        return Fragment.State.PRISTINE;
    }
}

