/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.storage.sql.PropertyType;

public abstract class BaseProperty {
    protected final String name;
    public final PropertyType type;
    private final boolean readonly;

    public BaseProperty(String name, PropertyType type, boolean readonly) {
        this.name = name;
        this.type = type;
        this.readonly = readonly;
    }

    public String getName() {
        return this.name;
    }

    public void refresh(boolean keepChanges) {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void save() {
        throw new UnsupportedOperationException();
    }

    protected void checkWritable() {
        if (this.readonly) {
            throw new ReadOnlyPropertyException(this.name);
        }
    }
}

