/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.event;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;
import org.nuxeo.runtime.services.event.ListenerDescriptor;

public class EventService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.EventService");
    private static final Log log = LogFactory.getLog(EventService.class);
    private final Map<String, ListenerList> topics = new HashMap<String, ListenerList>();
    private final Map<String, Object[]> contributions = new Hashtable<String, Object[]>();

    @Override
    public void deactivate(ComponentContext context) {
        this.topics.clear();
        this.contributions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerExtension(Extension extension) {
        Object[] descriptors = extension.getContributions();
        if (ArrayUtils.isEmpty((Object[])descriptors)) {
            return;
        }
        String name = extension.getId();
        EventService eventService = this;
        synchronized (eventService) {
            for (Object desc : descriptors) {
                ListenerDescriptor lDesc = (ListenerDescriptor)desc;
                for (String topic : lDesc.topics) {
                    this.addListener(topic, lDesc.listener);
                }
            }
            this.contributions.put(name, descriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterExtension(Extension extension) {
        String name = extension.getId();
        EventService eventService = this;
        synchronized (eventService) {
            Object[] descriptors = this.contributions.remove(name);
            if (descriptors != null) {
                for (Object desc : descriptors) {
                    ListenerDescriptor lDesc = (ListenerDescriptor)desc;
                    for (String topic : lDesc.topics) {
                        this.removeListener(topic, lDesc.listener);
                    }
                }
            }
        }
    }

    public void sendEvent(Event event) {
        ListenerList list = this.topics.get(event.getTopic());
        if (list == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Event sent to topic " + event.getTopic() + ". Ingnoring"));
            }
        } else {
            EventService.sendEvent(list, event);
        }
    }

    public synchronized void addListener(String topic, EventListener listener) {
        ListenerList list = this.topics.get(topic);
        if (list == null) {
            list = new ListenerList();
            this.topics.put(topic, list);
        }
        list.add((Object)listener);
    }

    public synchronized void removeListener(String topic, EventListener listener) {
        ListenerList list = this.topics.get(topic);
        if (list != null) {
            list.remove((Object)listener);
            if (list.isEmpty()) {
                this.topics.remove(topic);
            }
        }
    }

    private static void sendEvent(ListenerList list, Event event) {
        Object[] listeners;
        for (Object listener : listeners = list.getListeners()) {
            ((EventListener)listener).handleEvent(event);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return (T)(adapter == this.getClass() ? this : null);
    }
}

