/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ExtensionDescriptorReader;
import org.w3c.dom.Element;

@XObject(value="extension")
public class ExtensionImpl
implements Extension {
    private static int cnt = 0;
    private static final long serialVersionUID = 8504100747683248986L;
    private static final ExtensionDescriptorReader reader = new ExtensionDescriptorReader();
    @XNode(value="@target")
    ComponentName target;
    @XNode(value="@point")
    String extensionPoint;
    @XNode(value="@id")
    private String id;
    @XContent(value="documentation")
    String documentation;
    @XNode(value="")
    transient Element element;
    transient Object[] contributions;
    transient ComponentInstance component;

    @Override
    public void dispose() {
        this.element = null;
        this.contributions = null;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public String getExtensionPoint() {
        return this.extensionPoint;
    }

    @Override
    public ComponentName getTargetComponent() {
        return this.target;
    }

    @Override
    public Object[] getContributions() {
        return this.contributions;
    }

    @Override
    public void setContributions(Object[] contributions) {
        this.contributions = contributions;
    }

    @Override
    public void setComponent(ComponentInstance component) {
        this.component = component;
    }

    @Override
    public ComponentInstance getComponent() {
        return this.component;
    }

    @Override
    public RuntimeContext getContext() {
        return this.component.getContext();
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.component != null ? this.component.getName().getName() + '#' + this.extensionPoint + '.' + cnt++ : "null#" + this.extensionPoint + '.' + cnt++;
        }
        return this.id;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ExtensionImpl.class.getSimpleName());
        buf.append(" {");
        buf.append("target: ");
        buf.append(this.target);
        buf.append(", point:");
        buf.append(this.extensionPoint);
        buf.append(", contributor:");
        buf.append(this.component);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public String toXML() {
        try {
            return DOMSerializer.toStringOmitXml((Element)this.element);
        }
        catch (IOException e) {
            System.err.println("Failed to serialize extension " + e);
            return null;
        }
    }

    public static ExtensionImpl fromXML(RuntimeContext context, String xml) throws IOException {
        return reader.read(context, new ByteArrayInputStream(xml.getBytes()));
    }
}

