/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deploy;

import org.nuxeo.runtime.deploy.Contribution;
import org.nuxeo.runtime.deploy.ContributionManager;
import org.nuxeo.runtime.deploy.ManagedComponent;

public abstract class ExtensibleContribution
extends Contribution {
    protected ExtensibleContribution baseContribution;
    protected String baseContributionId;

    protected abstract void copyOver(ExtensibleContribution var1);

    public String getBaseContributionId() {
        return this.baseContributionId;
    }

    public void setBaseContribution(ExtensibleContribution baseContribution) {
        this.baseContribution = baseContribution;
    }

    public void setBaseContributionId(String baseContributionId) {
        this.baseContributionId = baseContributionId;
    }

    @Override
    public void resolve(ContributionManager mgr) {
        if (this.baseContributionId != null) {
            this.baseContribution = (ExtensibleContribution)mgr.getResolved(this.baseContributionId);
        }
    }

    @Override
    public void unresolve(ContributionManager mgr) {
        this.baseContribution = null;
    }

    public ExtensibleContribution getBaseContribution() {
        return this.baseContribution;
    }

    public ExtensibleContribution getRootContribution() {
        return this.baseContribution == null ? this : this.baseContribution.getRootContribution();
    }

    public boolean isRootContribution() {
        return this.baseContribution == null;
    }

    protected ExtensibleContribution getMergedContribution() {
        if (this.baseContribution == null) {
            return this.clone();
        }
        ExtensibleContribution mc = this.baseContribution.getMergedContribution();
        this.copyOver(mc);
        mc.contributionId = this.contributionId;
        mc.baseContributionId = this.baseContributionId;
        return mc;
    }

    @Override
    public void install(ManagedComponent comp) {
        this.install(comp, this.getMergedContribution());
    }

    @Override
    public void uninstall(ManagedComponent comp) {
        this.uninstall(comp, this.getMergedContribution());
    }

    public ExtensibleContribution clone() {
        ExtensibleContribution clone;
        try {
            clone = (ExtensibleContribution)this.getClass().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate the contribution class. Contribution classes must have a trivial constructor", e);
        }
        this.copyOver(clone);
        clone.contributionId = this.contributionId;
        clone.baseContributionId = this.baseContributionId;
        return clone;
    }
}

