/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.api.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;

public class RelationDate {
    private RelationDate() {
    }

    protected static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public static Literal getLiteralDate(Date date) {
        return new LiteralImpl(RelationDate.getDateFormat().format(date));
    }

    public static Literal getLiteralDate(Calendar cal) {
        return RelationDate.getLiteralDate(cal.getTime());
    }

    public static Date getDate(Literal dateLiteral) {
        Date date = null;
        if (dateLiteral != null) {
            String dateString = dateLiteral.getValue();
            try {
                date = RelationDate.getDateFormat().parse(dateString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Calendar getCalendar(Literal dateLiteral) {
        Calendar cal = Calendar.getInstance();
        Date date = RelationDate.getDate(dateLiteral);
        if (date == null) {
            return null;
        }
        cal.setTime(date);
        return cal;
    }
}

