/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.monitoring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.management.events.EventMonitoring;

@Name(value="eventMonitoringAction")
@Scope(value=ScopeType.EVENT)
public class EventMonitoringActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected EventMonitoring monitor;

    protected EventMonitoring getEventMonitoring() {
        if (this.monitor == null) {
            this.monitor = new EventMonitoring();
        }
        return this.monitor;
    }

    public int getActiveThreads() {
        return this.getEventMonitoring().getActiveThreadsCount();
    }

    public int getQueuedEvents() {
        return this.getEventMonitoring().getEventsInQueueCount();
    }

    @Factory(value="eventSyncStats", scope=ScopeType.EVENT)
    public List<List<String>> getSyncStats() {
        String stats = this.getEventMonitoring().getSyncHandlersExecTime();
        return this.formatStats(stats);
    }

    @Factory(value="eventAsyncStats", scope=ScopeType.EVENT)
    public List<List<String>> getAsyncStats() {
        String stats = this.getEventMonitoring().getAsyncHandlersExecTime();
        return this.formatStats(stats);
    }

    protected List<List<String>> formatStats(String stats) {
        String[] lines;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (stats == null || stats.length() == 0) {
            return result;
        }
        for (String line : lines = stats.split("\n")) {
            if ((line = line.trim()).length() == 0) continue;
            String[] parts = line.split(" - ");
            List<String> lin = Arrays.asList(parts);
            result.add(lin);
        }
        return result;
    }

    public void refresh() {
        this.cleanSeamEventCache();
    }

    public String getEventStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("Active Threads : ");
        sb.append(this.getEventMonitoring().getActiveThreadsCount());
        sb.append("\nQueued events : ");
        sb.append(this.getEventMonitoring().getEventsInQueueCount());
        sb.append("\nSync processing time : ");
        if (this.getEventMonitoring().isSyncHandlersTrackingEnabled()) {
            sb.append(this.getEventMonitoring().getSyncHandlersExecTime());
        } else {
            sb.append("[tracking not enabled]");
        }
        sb.append("\nAsync processing time : ");
        if (this.getEventMonitoring().isAsyncHandlersTrackingEnabled()) {
            sb.append(this.getEventMonitoring().getAsyncHandlersExecTime());
        } else {
            sb.append("[tracking not enabled]");
        }
        return sb.toString();
    }

    protected void cleanSeamEventCache() {
        Contexts.getEventContext().remove("eventSyncTrackingEnabled");
        Contexts.getEventContext().remove("eventAsyncTrackingEnabled");
        Contexts.getEventContext().remove("eventSyncStats");
        Contexts.getEventContext().remove("eventAsyncStats");
    }

    public void enableSyncTracking() {
        this.getEventMonitoring().setSyncHandlersTrackingEnabled(true);
        this.cleanSeamEventCache();
    }

    public void enableAsyncTracking() {
        this.getEventMonitoring().setAsyncHandlersTrackingEnabled(true);
        this.cleanSeamEventCache();
    }

    public void disableSyncTracking() {
        this.getEventMonitoring().setSyncHandlersTrackingEnabled(false);
        this.cleanSeamEventCache();
    }

    public void disableAsyncTracking() {
        this.getEventMonitoring().setAsyncHandlersTrackingEnabled(false);
        this.cleanSeamEventCache();
    }

    @Factory(value="eventSyncTrackingEnabled", scope=ScopeType.EVENT)
    public boolean isSyncTrackingEnabled() {
        return this.getEventMonitoring().isSyncHandlersTrackingEnabled();
    }

    @Factory(value="eventAsyncTrackingEnabled", scope=ScopeType.EVENT)
    public boolean isAsyncTrackingEnabled() {
        return this.getEventMonitoring().isAsyncHandlersTrackingEnabled();
    }
}

