/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.processor;

import com.vaadin.sass.internal.ScssStylesheet;
import com.vaadin.sass.internal.handler.SCSSDocumentHandlerImpl;
import com.vaadin.sass.internal.handler.SCSSErrorHandler;
import com.vaadin.sass.internal.parser.ParseException;
import com.vaadin.sass.internal.parser.Parser;
import com.vaadin.sass.internal.parser.SCSSParseException;
import com.vaadin.sass.internal.tree.Node;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.wro.processor.AbstractFlavorProcessor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.FlavorDescriptor;
import org.nuxeo.theme.styling.service.descriptors.SassImport;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;

@SupportedResourceType(value=ResourceType.CSS)
public class SassCssFlavorProcessor
extends AbstractFlavorProcessor {
    private static final Log log = LogFactory.getLog(SassCssFlavorProcessor.class);
    public static final String ALIAS = "sassCss";

    @Override
    public void process(Resource resource, Reader reader, Writer writer, String flavorName) throws IOException {
        block15: {
            block14: {
                Reader finalReader;
                block13: {
                    if (!this.isEnabled(resource)) break block14;
                    finalReader = null;
                    try {
                        List sassVars;
                        ThemeStylingService s;
                        FlavorDescriptor fd;
                        String varContents = "";
                        if (flavorName != null && (fd = (s = (ThemeStylingService)Framework.getService(ThemeStylingService.class)).getFlavor(flavorName)) != null && (sassVars = fd.getSassImports()) != null) {
                            for (SassImport var : sassVars) {
                                varContents = varContents + var.getContent();
                            }
                        }
                        InputSource source = null;
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{varContents})) {
                            byte[] varBytes = varContents.getBytes();
                            byte[] initalBytes = IOUtils.toByteArray((Reader)reader);
                            reader.close();
                            byte[] finalBytes = ArrayUtils.addAll((byte[])varBytes, (byte[])initalBytes);
                            finalReader = new InputStreamReader(new ByteArrayInputStream(finalBytes));
                        } else {
                            finalReader = reader;
                        }
                        source = new InputSource(finalReader);
                        source.setEncoding(this.getEncoding());
                        SCSSDocumentHandlerImpl scssDocumentHandlerImpl = new SCSSDocumentHandlerImpl();
                        ScssStylesheet stylesheet = scssDocumentHandlerImpl.getStyleSheet();
                        Parser parser = new Parser();
                        parser.setErrorHandler((ErrorHandler)new SCSSErrorHandler());
                        parser.setDocumentHandler((DocumentHandler)scssDocumentHandlerImpl);
                        try {
                            parser.parseStyleSheet(source);
                        }
                        catch (ParseException e) {
                            log.error((Object)("Error while parsing resource " + resource.getUri()), (Throwable)e);
                            throw WroRuntimeException.wrap((Exception)new SCSSParseException(e, resource.getUri()));
                        }
                        stylesheet.setCharset(this.getEncoding());
                        stylesheet.addSourceUris(Arrays.asList(resource.getUri()));
                        stylesheet.compile();
                        StringBuilder string = new StringBuilder("");
                        String delimeter = "\n\n";
                        List children = stylesheet.getChildren();
                        if (children.size() > 0) {
                            string.append(ScssStylesheet.PRINT_STRATEGY.build((Node)children.get(0)));
                        }
                        if (children.size() > 1) {
                            for (int i = 1; i < children.size(); ++i) {
                                String childString = ScssStylesheet.PRINT_STRATEGY.build((Node)children.get(i));
                                if (childString == null) continue;
                                string.append(delimeter).append(childString);
                            }
                        }
                        String content = string.toString();
                        writer.write(content);
                        writer.flush();
                        if (finalReader == null) break block13;
                        finalReader.close();
                    }
                    catch (Exception e) {
                        try {
                            log.error((Object)("Error while serving resource " + resource.getUri()), (Throwable)e);
                            throw WroRuntimeException.wrap((Exception)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(finalReader);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeQuietly((Reader)finalReader);
                break block15;
            }
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }
}

