/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.Processor;
import org.nuxeo.ecm.web.resources.wro.factory.NuxeoWroCacheKeyFactory;
import org.nuxeo.ecm.web.resources.wro.factory.NuxeoWroModelFactory;
import org.nuxeo.ecm.web.resources.wro.provider.NuxeoConfigurableProvider;
import ro.isdc.wro.cache.factory.CacheKeyFactory;
import ro.isdc.wro.manager.factory.ConfigurableWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;

public class NuxeoWroManagerFactory
extends ConfigurableWroManagerFactory {
    private static final Log log = LogFactory.getLog(NuxeoWroManagerFactory.class);

    protected Properties newConfigProperties() {
        Properties props = new Properties();
        this.addAliases(props, "preProcessors", "wroPre");
        this.addAliases(props, "postProcessors", "wroPost");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Built new conf, properties=" + props));
        }
        return props;
    }

    protected List<String> resolveProcessorNames(String type) {
        ArrayList<String> res = new ArrayList<String>();
        List<Processor> procs = NuxeoConfigurableProvider.resolveProcessors(type);
        for (Processor proc : procs) {
            res.add(proc.getName());
        }
        return res;
    }

    protected void addAliases(Properties props, String propName, String type) {
        String[] existing;
        String SEP = ",";
        List<String> procs = this.resolveProcessorNames(type);
        String propValue = props.getProperty(propName);
        if (!StringUtils.isBlank((String)propValue) && (existing = StringUtils.split((String)propValue, (String)",")) != null) {
            for (String s : existing) {
                if (s == null) continue;
                procs.add(s.trim());
            }
        }
        props.put(propName, StringUtils.join(procs, (String)","));
    }

    protected WroModelFactory newModelFactory() {
        return new NuxeoWroModelFactory();
    }

    protected CacheKeyFactory newCacheKeyFactory() {
        return new NuxeoWroCacheKeyFactory();
    }
}

