/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.factory;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.factory.DefaultCacheKeyFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;

public class NuxeoWroCacheKeyFactory
extends DefaultCacheKeyFactory {
    private static final Log log = LogFactory.getLog(NuxeoWroCacheKeyFactory.class);
    @Inject
    private GroupExtractor groupExtractor;
    @Inject
    private ReadOnlyContext context;

    public CacheKey create(HttpServletRequest request) {
        Map params;
        Validate.notNull((Object)request);
        CacheKey key = super.create(request);
        if (key != null && (params = URIUtils.getRequestParameters((String)request.getQueryString())) != null) {
            for (Map.Entry entry : params.entrySet()) {
                key.addAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Cache key for request '%s' '%s': %s", request.getRequestURL(), request.getQueryString(), key));
        }
        return key;
    }
}

