/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.util.LinkedList;
import java.util.Stack;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;

public abstract class BasedTracer
implements OperationCallback {
    protected final TracerFactory factory;
    protected final LinkedList<Call> calls = new LinkedList();
    protected Stack<Trace> callingStacks = new Stack();
    protected Call parent;
    protected OperationType chain;
    protected Trace trace;
    protected Boolean printable;

    protected BasedTracer(TracerFactory factory, Boolean printable) {
        this.factory = factory;
        this.printable = printable;
    }

    protected void pushContext(OperationType newChain) {
        if (this.chain != null) {
            this.callingStacks.push(new Trace(this.parent, this.chain, this.calls));
            this.parent = this.calls.isEmpty() ? null : this.calls.getLast();
            this.calls.clear();
        }
        this.chain = newChain;
    }

    protected void popContext() {
        this.calls.clear();
        if (this.callingStacks.isEmpty()) {
            this.parent = null;
            this.chain = null;
            return;
        }
        Trace trace = this.callingStacks.pop();
        this.parent = trace.parent;
        this.chain = trace.chain;
        this.calls.addAll(trace.operations);
    }

    protected void saveTrace(Trace popped) {
        if (this.parent == null) {
            this.trace = popped;
            this.chain = null;
            this.calls.clear();
            this.factory.onTrace(popped);
        } else {
            this.parent.nested.add(popped);
            this.popContext();
        }
    }

    @Override
    public void onChain(OperationType chain) {
        this.pushContext(chain);
    }

    @Override
    public void onOutput(Object output) {
        this.saveTrace(new Trace(this.parent, this.chain, this.calls, output));
    }

    @Override
    public void onError(OperationException error) {
        this.saveTrace(new Trace(this.parent, this.chain, this.calls, error));
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public String getFormattedText() {
        return this.printable != false ? this.trace.getFormattedText() : "";
    }
}

