/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.FollowLifecycleTransition", category="Document", label="Follow Life Cycle Transition", description="Follow the given transition on the input document life cycle state", aliases={"Document.SetLifeCycle"})
public class SetDocumentLifeCycle {
    public static final String ID = "Document.FollowLifecycleTransition";
    @Context
    protected CoreSession session;
    @Param(name="value")
    protected String value;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.session.followTransition(doc.getRef(), this.value);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) {
        this.session.followTransition(doc, this.value);
        return this.session.getDocument(doc);
    }
}

