/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.util.PDFMergerUtility;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Blob.ConcatenatePDFs", category="Conversion", label="Concatenate PDFs", description="Given a File document holding a pdf on the file:content property and 2 pdfs on the files:files property, the following operation will provide a pdf that is the result of the merge of all the pdfs, with the content of the one in file:content property first.")
public class ConcatenatePDFs {
    public static final String ID = "Blob.ConcatenatePDFs";
    @Context
    protected OperationContext ctx;
    @Param(name="blob_to_append", required=false, description="Optional blob reference in context to append in first place.")
    protected String xpathBlobToAppend = "";
    @Param(name="filename", required=true, description="The merge pdf result filename.")
    protected String filename;

    @OperationMethod
    public Blob run(Blob blob) throws OperationException, IOException, COSVisitorException {
        PDFMergerUtility ut = new PDFMergerUtility();
        this.checkPdf(blob);
        if (this.xpathBlobToAppend.isEmpty()) {
            return blob;
        }
        this.handleBlobToAppend(ut);
        ut.addSource(blob.getStream());
        return this.appendPDFs(ut);
    }

    @OperationMethod
    public Blob run(BlobList blobs) throws IOException, OperationException, COSVisitorException {
        PDFMergerUtility ut = new PDFMergerUtility();
        if (!this.xpathBlobToAppend.isEmpty()) {
            this.handleBlobToAppend(ut);
        }
        for (Blob blob : blobs) {
            this.checkPdf(blob);
            ut.addSource(blob.getStream());
        }
        return this.appendPDFs(ut);
    }

    protected Blob appendPDFs(PDFMergerUtility ut) throws IOException, COSVisitorException {
        File tempFile = Framework.createTempFile((String)this.filename, (String)".pdf");
        ut.setDestinationFileName(tempFile.getAbsolutePath());
        ut.mergeDocuments();
        Blob fb = Blobs.createBlob((File)tempFile);
        Framework.trackFile((File)tempFile, (Object)fb);
        fb.setFilename(this.filename);
        return fb;
    }

    protected void handleBlobToAppend(PDFMergerUtility ut) throws IOException, OperationException {
        try {
            Blob blobToAppend = (Blob)this.ctx.get(this.xpathBlobToAppend);
            if (blobToAppend == null) {
                throw new OperationException("The blob to append from variable context: '" + this.xpathBlobToAppend + "' is null.");
            }
            this.checkPdf(blobToAppend);
            ut.addSource(blobToAppend.getStream());
        }
        catch (ClassCastException e) {
            throw new OperationException("The blob to append from variable context: '" + this.xpathBlobToAppend + "' is not a blob.", e);
        }
    }

    protected void checkPdf(Blob blob) throws OperationException {
        if (!"application/pdf".equals(blob.getMimeType())) {
            throw new OperationException("Blob " + blob.getFilename() + " is not a PDF.");
        }
    }
}

