/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationParameters;

public class OperationChain
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String id;
    protected final List<OperationParameters> operations;
    protected final Map<String, Object> chainParameters;
    protected String description;
    protected String[] aliases;
    protected boolean isPublic;

    public OperationChain(String id) {
        this.id = id;
        this.operations = new ArrayList<OperationParameters>();
        this.chainParameters = new HashMap<String, Object>();
    }

    public OperationChain(String id, List<OperationParameters> operations) {
        this.id = id;
        this.operations = operations;
        this.chainParameters = new HashMap<String, Object>();
    }

    public OperationChain(String id, List<OperationParameters> operations, Map<String, Object> chainParameters) {
        this.id = id;
        this.operations = operations;
        this.chainParameters = chainParameters;
    }

    public String getId() {
        return this.id;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public List<OperationParameters> getOperations() {
        return this.operations;
    }

    public void add(OperationParameters op) {
        this.operations.add(op);
    }

    public OperationParameters add(String operationId) {
        OperationParameters op = new OperationParameters(operationId);
        this.operations.add(op);
        return op;
    }

    public void addChainParameters(Map<String, Object> chainParameter) {
        this.chainParameters.putAll(chainParameter);
    }

    public Map<String, Object> getChainParameters() {
        return this.chainParameters;
    }
}

